/*
 * Decompiled with CFR 0.152.
 */
package one.nio.util;

import java.util.Arrays;

public final class Hex {
    public static final char[] SMALL;
    public static final char[] CAPITAL;
    public static final int[] DIGIT_VALUE;

    public static String toHex(byte[] input) {
        return Hex.toHex(input, SMALL);
    }

    public static String toHex(byte[] input, char[] digits) {
        char[] result = new char[input.length * 2];
        int i = 0;
        for (byte b : input) {
            result[i] = digits[(b & 0xFF) >>> 4];
            result[i + 1] = digits[b & 0xF];
            i += 2;
        }
        return new String(result);
    }

    public static String toHex(int n) {
        return Hex.toHex(n, SMALL);
    }

    public static String toHex(int n, char[] digits) {
        char[] result = new char[8];
        int i = 8;
        while (i-- > 0) {
            result[i] = digits[n & 0xF];
            n >>>= 4;
        }
        return new String(result);
    }

    public static String toHex(long n) {
        return Hex.toHex(n, SMALL);
    }

    public static String toHex(long n, char[] digits) {
        char[] result = new char[16];
        int i = 16;
        while (i-- > 0) {
            result[i] = digits[(int)n & 0xF];
            n >>>= 4;
        }
        return new String(result);
    }

    public static byte[] parseBytes(String input) {
        int length = input.length();
        byte[] result = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            result[i >>> 1] = (byte)(DIGIT_VALUE[input.charAt(i)] << 4 | DIGIT_VALUE[input.charAt(i + 1)]);
        }
        return result;
    }

    public static int parseInt(String input) {
        int length = input.length();
        int result = 0;
        for (int i = 0; i < length; ++i) {
            int digit = DIGIT_VALUE[input.charAt(i)];
            if (digit < 0) {
                throw new IllegalArgumentException();
            }
            result = result << 4 | digit;
        }
        return result;
    }

    public static long parseLong(String input) {
        int length = input.length();
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            int digit = DIGIT_VALUE[input.charAt(i)];
            if (digit < 0) {
                throw new IllegalArgumentException();
            }
            result = result << 4 | (long)digit;
        }
        return result;
    }

    static {
        int i;
        SMALL = "0123456789abcdef".toCharArray();
        CAPITAL = "0123456789ABCDEF".toCharArray();
        DIGIT_VALUE = new int[256];
        Arrays.fill(DIGIT_VALUE, -1);
        for (i = 0; i <= 9; ++i) {
            Hex.DIGIT_VALUE[48 + i] = i;
        }
        for (i = 10; i <= 15; ++i) {
            Hex.DIGIT_VALUE[55 + i] = i;
            Hex.DIGIT_VALUE[87 + i] = i;
        }
    }
}

