/*
 * Decompiled with CFR 0.152.
 */
package one.nio.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ThreadLocalRandom;
import one.nio.cluster.Cluster;
import one.nio.cluster.ServiceProvider;
import one.nio.cluster.ServiceUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightCluster<T extends ServiceProvider>
implements Cluster<T> {
    protected static final Logger log = LoggerFactory.getLogger(WeightCluster.class);
    protected final HashMap<T, Integer> providers = new HashMap();
    protected Timer monitorTimer = new Timer("Cluster monitor", true);
    protected long monitorTimeout = 1000L;
    protected volatile ProviderSelector providerSelector;

    public WeightCluster() {
        this.rebuildProviderSelector();
    }

    public synchronized void close() {
        this.monitorTimer.cancel();
        for (ServiceProvider provider : this.providers.keySet()) {
            provider.close();
        }
    }

    public long getMonitorTimeout() {
        return this.monitorTimeout;
    }

    public void setMonitorTimeout(long monitorTimeout) {
        this.monitorTimeout = monitorTimeout;
    }

    @Override
    public T getProvider() throws ServiceUnavailableException {
        return this.providerSelector.select();
    }

    @Override
    public void enableProvider(T provider) {
        if (provider.enable()) {
            log.info("Enabled {}", provider);
            this.rebuildProviderSelector();
        }
    }

    @Override
    public void disableProvider(T provider) {
        if (provider.disable()) {
            log.info("Disabled {}", provider);
            this.rebuildProviderSelector();
            this.monitorTimer.schedule((TimerTask)new MonitoringTask(this, provider), this.monitorTimeout, this.monitorTimeout);
        }
    }

    public synchronized void addProvider(T provider, int weight) {
        Integer oldWeight = this.providers.put(provider, weight);
        if (oldWeight == null || oldWeight != weight) {
            this.rebuildProviderSelector();
        }
    }

    public synchronized void addProviders(Map<T, Integer> newProviders) {
        this.providers.putAll(newProviders);
        this.rebuildProviderSelector();
    }

    public synchronized void removeProvider(T provider) {
        if (this.providers.remove(provider) != null) {
            this.rebuildProviderSelector();
        }
    }

    public synchronized void removeProviders(Collection<T> oldProviders) {
        this.providers.keySet().removeAll(oldProviders);
        this.rebuildProviderSelector();
    }

    public synchronized List<T> replaceProviders(Map<T, Integer> newProviders) {
        ArrayList<T> oldProviders = new ArrayList<T>(this.providers.keySet());
        this.providers.clear();
        this.providers.putAll(newProviders);
        this.rebuildProviderSelector();
        return oldProviders;
    }

    public synchronized Integer getWeight(T provider) {
        return this.providers.get(provider);
    }

    protected synchronized void rebuildProviderSelector() {
        this.providerSelector = new ProviderSelector(this.providers);
    }

    public static class MonitoringTask
    extends TimerTask {
        public final T provider;
        final /* synthetic */ WeightCluster this$0;

        public MonitoringTask(T provider) {
            this.this$0 = this$0;
            this.provider = provider;
        }

        @Override
        public void run() {
            try {
                if (this.this$0.getWeight(this.provider) == null) {
                    this.cancel();
                    return;
                }
                if (!this.provider.available() && this.provider.check()) {
                    this.this$0.enableProvider(this.provider);
                }
                if (this.provider.available()) {
                    this.cancel();
                }
            }
            catch (Throwable e) {
                log.warn("{} is not available", this.provider, (Object)e);
            }
        }
    }

    public class ProviderSelector {
        public final T[] providers;
        public final int[] weights;
        public final int weightRange;

        public ProviderSelector(Map<T, Integer> providers) {
            int size = providers.size();
            this.providers = new ServiceProvider[size];
            this.weights = new int[size];
            int weightRange = 0;
            int index = 0;
            for (Map.Entry entry : providers.entrySet()) {
                ServiceProvider provider = (ServiceProvider)entry.getKey();
                if (provider.available()) {
                    weightRange += entry.getValue().intValue();
                }
                this.providers[index] = provider;
                this.weights[index] = weightRange;
                ++index;
            }
            this.weightRange = weightRange;
        }

        public T select() throws ServiceUnavailableException {
            if (this.weightRange > 0) {
                int w = ThreadLocalRandom.current().nextInt(this.weightRange);
                int low = 0;
                int high = this.weights.length - 1;
                while (low < high) {
                    int med = low + high >>> 1;
                    if (w < this.weights[med]) {
                        high = med;
                        continue;
                    }
                    low = med + 1;
                }
                return this.providers[low];
            }
            throw new ServiceUnavailableException("No providers available");
        }
    }
}

