/*
 * Decompiled with CFR 0.152.
 */
package one.nio.http;

import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import one.nio.cluster.ServiceUnavailableException;
import one.nio.cluster.WeightCluster;
import one.nio.http.HttpProvider;
import one.nio.http.Request;
import one.nio.http.Response;
import one.nio.net.ConnectionString;

public class HttpCluster
extends WeightCluster<HttpProvider> {
    protected volatile int retries = 3;
    protected volatile int maxFailures = 5;
    protected volatile boolean logTimeouts;

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setMaxFailures(int maxFailures) {
        this.maxFailures = maxFailures;
    }

    public void setLogTimeouts(boolean logTimeouts) {
        this.logTimeouts = logTimeouts;
    }

    public void configure(String configuration) {
        Map<HttpProvider, Integer> newProviders = this.createProviders(configuration);
        List<HttpProvider> oldProviders = this.replaceProviders(newProviders);
        for (HttpProvider provider : oldProviders) {
            provider.close();
        }
    }

    protected Map<HttpProvider, Integer> createProviders(String configuration) {
        HashMap<HttpProvider, Integer> providers = new HashMap<HttpProvider, Integer>();
        StringTokenizer st = new StringTokenizer(configuration);
        while (st.hasMoreTokens()) {
            HttpProvider provider = this.createProvider(st.nextToken());
            int weight = Integer.parseInt(st.nextToken());
            providers.put(provider, weight);
        }
        return providers;
    }

    protected HttpProvider createProvider(String provider) {
        return new HttpProvider(new ConnectionString(provider));
    }

    public Response invoke(Request request) throws ServiceUnavailableException {
        log.trace("{}", (Object)request);
        int retries = this.retries;
        for (int i = 0; i < retries; ++i) {
            HttpProvider provider = (HttpProvider)this.getProvider();
            try {
                Response response = provider.invoke(request);
                provider.getFailures().set(0);
                return response;
            }
            catch (Exception e) {
                if (provider.getFailures().incrementAndGet() >= this.maxFailures) {
                    this.disableProvider(provider);
                }
                if ((e instanceof SocketTimeoutException || e.getCause() instanceof SocketTimeoutException) && !log.isTraceEnabled() && !this.logTimeouts) {
                    log.debug("{} timed out", (Object)provider);
                    continue;
                }
                log.warn("{} invocation failed {}", new Object[]{provider, request.getURI(), e});
                continue;
            }
        }
        throw new ServiceUnavailableException("Cluster invocation failed");
    }
}

