/*
 * Decompiled with CFR 0.152.
 */
package one.nio.http;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import one.nio.cluster.ServiceProvider;
import one.nio.http.HttpClient;
import one.nio.http.Request;
import one.nio.http.Response;
import one.nio.net.ConnectionString;

public class HttpProvider
implements ServiceProvider {
    private final HttpClient client;
    private final AtomicBoolean available;
    private final AtomicInteger failures;

    public HttpProvider(ConnectionString conn) {
        this(new HttpClient(conn));
    }

    public HttpProvider(HttpClient client) {
        this.client = client;
        this.available = new AtomicBoolean(true);
        this.failures = new AtomicInteger();
    }

    public Response invoke(Request request) throws Exception {
        Response response = this.client.invoke(request);
        if (response.getStatus() >= 500) {
            throw new IOException(this + " call failed with status " + response.getHeaders()[0]);
        }
        return response;
    }

    public AtomicInteger getFailures() {
        return this.failures;
    }

    @Override
    public boolean available() {
        return this.available.get();
    }

    @Override
    public boolean check() throws Exception {
        Response response = this.client.head("/", new String[0]);
        if (response.getStatus() >= 500) {
            throw new IOException(this + " check failed with status " + response.getHeaders()[0]);
        }
        return true;
    }

    @Override
    public boolean enable() {
        if (this.available.compareAndSet(false, true)) {
            this.failures.set(0);
            return true;
        }
        return false;
    }

    @Override
    public boolean disable() {
        this.client.invalidateAll();
        return this.available.compareAndSet(true, false);
    }

    @Override
    public void close() {
        this.available.set(false);
        this.client.close();
    }

    public String toString() {
        return "HttpProvider[" + this.client.name() + "]";
    }
}

