/*
 * Decompiled with CFR 0.152.
 */
package one.nio.http;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import one.nio.http.HttpServerConfig;
import one.nio.http.HttpSession;
import one.nio.http.Path;
import one.nio.http.PathMapper;
import one.nio.http.Request;
import one.nio.http.RequestHandler;
import one.nio.http.RequestMethod;
import one.nio.http.Response;
import one.nio.http.VirtualHost;
import one.nio.http.gen.RequestHandlerGenerator;
import one.nio.net.Socket;
import one.nio.server.RejectedSessionException;
import one.nio.server.Server;

public class HttpServer
extends Server {
    private final PathMapper defaultMapper = new PathMapper();
    private final Map<String, PathMapper> mappersByAlias = new HashMap<String, PathMapper>();
    private final Map<String, PathMapper> mappersByHost = new HashMap<String, PathMapper>();

    public HttpServer(HttpServerConfig config, Object ... routers) throws IOException {
        super(config);
        if (config.virtualHosts != null) {
            for (Map.Entry entry : config.virtualHosts.entrySet()) {
                PathMapper mapper = new PathMapper();
                this.mappersByAlias.put((String)entry.getKey(), mapper);
                for (String host : (String[])entry.getValue()) {
                    this.mappersByHost.put(host.toLowerCase(), mapper);
                }
            }
        }
        this.addRequestHandlers(this);
        for (Object router : routers) {
            this.addRequestHandlers(router);
        }
    }

    @Override
    public HttpSession createSession(Socket socket) throws RejectedSessionException {
        return new HttpSession(socket, this);
    }

    public void handleRequest(Request request, HttpSession session) throws IOException {
        RequestHandler handler = this.findHandlerByHost(request);
        if (handler == null) {
            handler = this.defaultMapper.find(request.getPath(), request.getMethod());
        }
        if (handler != null) {
            handler.handleRequest(request, session);
        } else {
            this.handleDefault(request, session);
        }
    }

    public void handleDefault(Request request, HttpSession session) throws IOException {
        Response response = new Response("404 Not Found", Response.EMPTY);
        session.sendResponse(response);
    }

    public void addRequestHandlers(Object router) {
        ArrayList supers = new ArrayList(4);
        for (Class<?> cls = router.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
            supers.add(cls);
        }
        RequestHandlerGenerator generator = new RequestHandlerGenerator();
        int i = supers.size();
        while (--i >= 0) {
            Class cls = (Class)supers.get(i);
            VirtualHost virtualHost = cls.getAnnotation(VirtualHost.class);
            String[] aliases = virtualHost == null ? null : virtualHost.value();
            for (Method m : cls.getMethods()) {
                Path annotation = m.getAnnotation(Path.class);
                if (annotation == null) continue;
                RequestMethod requestMethod = m.getAnnotation(RequestMethod.class);
                int[] methods = requestMethod == null ? null : requestMethod.value();
                RequestHandler requestHandler = generator.generateFor(m, router);
                for (String path : annotation.value()) {
                    if (!path.startsWith("/")) {
                        throw new IllegalArgumentException("Path '" + path + "' is not absolute");
                    }
                    if (aliases == null || aliases.length == 0) {
                        this.defaultMapper.add(path, methods, requestHandler);
                        continue;
                    }
                    for (String alias : aliases) {
                        PathMapper mapper = this.mappersByAlias.get(alias);
                        if (mapper == null) continue;
                        mapper.add(path, methods, requestHandler);
                    }
                }
            }
        }
    }

    protected RequestHandler findHandlerByHost(Request request) {
        PathMapper mapper;
        String host;
        if (!this.mappersByHost.isEmpty() && (host = request.getHost()) != null && (mapper = this.mappersByHost.get(host.toLowerCase())) != null) {
            return mapper.find(request.getPath(), request.getMethod());
        }
        return null;
    }
}

