/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import java.io.IOException;
import one.nio.mem.SharedMemoryMap;
import one.nio.util.Hash;

public class SharedMemoryStringMap<V>
extends SharedMemoryMap<String, V> {
    public SharedMemoryStringMap(int capacity, String fileName, long fileSize) throws IOException {
        super(capacity, fileName, fileSize);
    }

    public SharedMemoryStringMap(int capacity, String fileName, long fileSize, long expirationTime) throws IOException {
        super(capacity, fileName, fileSize, expirationTime);
    }

    @Override
    protected String keyAt(long entry) {
        int keyLength = (int)(unsafe.getLong(entry + 0L) >>> 33);
        long keyOffset = entry + 24L;
        char[] key = new char[keyLength];
        int i = 0;
        while (i < keyLength) {
            key[i] = unsafe.getChar(keyOffset);
            ++i;
            keyOffset += 2L;
        }
        return new String(key);
    }

    @Override
    protected long hashCode(String key) {
        int stringHashCode = Hash.murmur3(key);
        return (long)key.length() << 33 | (long)stringHashCode & 0xFFFFFFFFL;
    }

    @Override
    protected boolean equalsAt(long entry, String key) {
        int keyLength = key.length();
        long keyOffset = entry + 24L;
        int i = 0;
        while (i < keyLength) {
            if (unsafe.getChar(keyOffset) != key.charAt(i)) {
                return false;
            }
            ++i;
            keyOffset += 2L;
        }
        return true;
    }

    @Override
    protected long allocateEntry(String key, long hashCode, int size) {
        int keyLength = key.length();
        long entry = this.allocator.segmentFor(hashCode).malloc(24 + keyLength * 2 + size);
        long keyOffset = entry + 24L;
        int i = 0;
        while (i < keyLength) {
            unsafe.putChar(keyOffset, key.charAt(i));
            ++i;
            keyOffset += 2L;
        }
        return entry;
    }

    @Override
    protected int headerSize(long entry) {
        int keySizeInBytes = (int)(unsafe.getLong(entry + 0L) >>> 32);
        return 24 + keySizeInBytes;
    }
}

