/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mgt;

import java.io.IOException;
import java.util.Set;
import javax.management.JMException;
import javax.management.ObjectName;
import one.nio.http.HttpServer;
import one.nio.http.HttpServerConfig;
import one.nio.http.HttpSession;
import one.nio.http.Param;
import one.nio.http.Path;
import one.nio.http.Request;
import one.nio.http.Response;
import one.nio.mgt.Management;
import one.nio.net.ConnectionString;
import one.nio.net.SslConfig;
import one.nio.server.AcceptorConfig;
import one.nio.util.Utf8;

public class ManagementServer
extends HttpServer {
    public ManagementServer(HttpServerConfig config, Object ... routers) throws IOException {
        super(config, routers);
    }

    public ManagementServer(String address, Object ... routers) throws IOException {
        super(ManagementServer.createConfigFromAddress(address), routers);
    }

    private static HttpServerConfig createConfigFromAddress(String address) {
        ConnectionString conn = new ConnectionString(address);
        AcceptorConfig acceptor = new AcceptorConfig();
        acceptor.address = conn.getHost();
        acceptor.port = conn.getPort();
        if ("ssl".equals(conn.getProtocol())) {
            acceptor.ssl = SslConfig.from(System.getProperties());
        }
        HttpServerConfig config = new HttpServerConfig();
        config.acceptors = new AcceptorConfig[]{acceptor};
        config.selectors = 1;
        return config;
    }

    @Override
    public void handleRequest(Request request, HttpSession session) throws IOException {
        try {
            super.handleRequest(request, session);
        }
        finally {
            session.scheduleClose();
        }
    }

    @Path(value={"/getstatus"})
    public Response getStatusResponse() {
        return Response.ok("OK");
    }

    @Path(value={"/monitor/mem"})
    public Response getMonitorMemResponse() {
        return this.getJmxResponse("one.nio.mem:type=MallocMT,*", "base", "TotalMemory,UsedMemory,FreeMemory");
    }

    @Path(value={"/monitor/shm"})
    public Response getMonitorShmResponse() {
        return this.getJmxResponse("one.nio.mem:type=SharedMemoryMap,*", "name", "TotalMemory,UsedMemory,FreeMemory,Capacity,Count");
    }

    @Path(value={"/monitor/server"})
    public Response getMonitorServerResponse() {
        return this.getJmxResponse("one.nio.server:type=Server,*", "port", "AcceptedSessions,Connections,RequestsProcessed,RequestsRejected,Workers,WorkersActive,SelectorMaxReady");
    }

    @Path(value={"/jmx"})
    public Response getJmxResponse(@Param(value="name") String name, @Param(value="prop=") String prop, @Param(value="attr") String attr) {
        if (name == null) {
            return new Response("400 Bad Request", Response.EMPTY);
        }
        try {
            Set<ObjectName> objNames = Management.resolvePattern(name);
            StringBuilder result = new StringBuilder();
            for (ObjectName objName : objNames) {
                result.append(objName.toString());
                if (prop != null) {
                    for (String property : prop.split(",")) {
                        result.append('\t').append(objName.getKeyProperty(property));
                    }
                }
                if (attr != null) {
                    for (Object value : Management.getAttributes(objName, attr.split(","))) {
                        result.append('\t').append(value);
                    }
                }
                result.append("\r\n");
            }
            return Response.ok(result.toString());
        }
        catch (JMException e) {
            String errorMessage = e.toString() + "\r\n";
            return new Response("500 Internal Server Error", Utf8.toBytes(errorMessage));
        }
    }
}

