/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mgt;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import one.nio.mgt.DiagnosticCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDumper {
    private static final Logger log = LoggerFactory.getLogger(ThreadDumper.class);
    private static final AtomicLong dumpTime = new AtomicLong();

    public static void dump(OutputStream out) {
        String threadDump;
        try {
            threadDump = DiagnosticCommand.execute("threadPrint", new String[0]);
        }
        catch (JMException e) {
            log.warn("Failed to get threads dump", (Throwable)e);
            return;
        }
        PrintStream printStream = out == null ? System.out : new PrintStream(out);
        printStream.println(threadDump);
    }

    public static void dump(OutputStream out, long minDumpInterval) {
        long lastDumpTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastDumpTime = dumpTime.get()) >= minDumpInterval && dumpTime.compareAndSet(lastDumpTime, currentTime)) {
            ThreadDumper.dump(out);
        }
    }
}

