/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.util.Arrays;
import java.util.Iterator;
import one.nio.mem.DirectMemory;
import one.nio.net.NativeSocket;
import one.nio.net.Selector;
import one.nio.net.Session;
import one.nio.util.JavaInternals;

final class NativeSelector
extends Selector {
    private static final int EPOLL_CTL_ADD = 1;
    private static final int EPOLL_CTL_DEL = 2;
    private static final int EPOLL_CTL_MOD = 3;
    private static final int EPOLL_HEADER_SIZE = 16;
    private static final int EPOLL_MAX_EVENTS = 1000;
    private static final int EPOLL_STRUCT_SIZE = 12;
    private static final int EPOLL_BUF_SIZE = 12016;
    private final int epollFD = NativeSelector.epollCreate();
    private final long epollStruct = DirectMemory.allocate(12016L, this) + 16L;
    private Session[] sessions = new Session[1024];
    private int size;
    private volatile int closeFlag;

    private static native int epollCreate();

    private static native void epollClose(int var0);

    private static native int epollWait(int var0, long var1, int var3);

    private static native void epollCtl(int var0, int var1, int var2, int var3, int var4);

    NativeSelector() {
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public boolean isOpen() {
        return this.closeFlag == 0;
    }

    @Override
    public final synchronized void close() {
        if (this.closeFlag == 0) {
            this.closeFlag = -1;
            this.size = 0;
            NativeSelector.epollClose(this.epollFD);
        }
    }

    @Override
    public final void register(Session session) {
        this.add(session);
        this.enable(session);
    }

    @Override
    public final void unregister(Session session) {
        this.remove(session);
        this.disable(session);
    }

    @Override
    public final void enable(Session session) {
        NativeSelector.epollCtl(this.epollFD, 1, ((NativeSocket)session.socket).fd, session.slot, session.eventsToListen);
    }

    @Override
    public final void disable(Session session) {
        NativeSelector.epollCtl(this.epollFD, 2, ((NativeSocket)session.socket).fd, session.slot, 0);
    }

    @Override
    public final void listen(Session session, int events) {
        NativeSelector.epollCtl(this.epollFD, 3, ((NativeSocket)session.socket).fd, session.slot, events);
    }

    @Override
    public final Iterator<Session> iterator() {
        return new Iterator<Session>(){
            private Session next = this.findNext(0);

            private Session findNext(int slot) {
                Session[] sessions = NativeSelector.this.sessions;
                while (slot < sessions.length) {
                    Session session = sessions[slot];
                    if (session != null) {
                        return session;
                    }
                    ++slot;
                }
                return null;
            }

            @Override
            public final boolean hasNext() {
                return this.next != null;
            }

            @Override
            public final Session next() {
                Session session = this.next;
                this.next = this.findNext(session.slot + 1);
                return session;
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final Iterator<Session> select() {
        final int count = NativeSelector.epollWait(this.epollFD, this.epollStruct, 1000) | this.closeFlag;
        return new Iterator<Session>(){
            private long nextAddr;
            private long lastAddr;
            private Session next;
            {
                this.nextAddr = NativeSelector.this.epollStruct;
                this.lastAddr = this.nextAddr + (long)(count * 12);
                this.next = this.findNext();
            }

            private Session findNext() {
                long currentAddr = this.nextAddr;
                while (currentAddr < this.lastAddr) {
                    Session session = NativeSelector.this.sessions[JavaInternals.unsafe.getInt(currentAddr + 4L)];
                    this.nextAddr = currentAddr + 12L;
                    if (session != null) {
                        session.events = JavaInternals.unsafe.getInt(currentAddr);
                        return session;
                    }
                    currentAddr = this.nextAddr;
                }
                return null;
            }

            @Override
            public final boolean hasNext() {
                return this.next != null;
            }

            @Override
            public final Session next() {
                Session handle = this.next;
                this.next = this.findNext();
                return handle;
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public long lastWakeupTime() {
        return JavaInternals.unsafe.getLong(this.epollStruct - 16L);
    }

    private synchronized void add(Session session) {
        if (++this.size > this.sessions.length) {
            this.sessions = Arrays.copyOf(this.sessions, this.sessions.length * 2);
        }
        int mask = this.sessions.length - 1;
        int slot = session.hashCode() & mask;
        while (true) {
            if (this.sessions[slot] == null) {
                session.selector = this;
                session.slot = slot;
                this.sessions[slot] = session;
                return;
            }
            slot = slot + 1 & mask;
        }
    }

    private synchronized void remove(Session session) {
        if (this.sessions[session.slot] == session) {
            this.sessions[session.slot] = null;
            session.selector = null;
            --this.size;
        }
    }
}

