/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.nio.channels.SelectableChannel;
import one.nio.net.Socket;
import one.nio.util.JavaInternals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SelectableJavaSocket
extends Socket {
    private static final Logger log = LoggerFactory.getLogger(SelectableJavaSocket.class);
    private static final MethodHandle poll = SelectableJavaSocket.getMethodHandle("sun.nio.ch.Net", "poll", FileDescriptor.class, Integer.TYPE, Long.TYPE);
    private static final MethodHandle getFD = SelectableJavaSocket.getMethodHandle("sun.nio.ch.SelChImpl", "getFD", new Class[0]);
    static final int POLL_READ = SelectableJavaSocket.getFieldValue("sun.nio.ch.Net", "POLLIN");
    static final int POLL_WRITE = SelectableJavaSocket.getFieldValue("sun.nio.ch.Net", "POLLOUT");

    private static MethodHandle getMethodHandle(String cls, String name, Class<?> ... params) {
        try {
            Method m = Class.forName(cls).getDeclaredMethod(name, params);
            JavaInternals.setAccessible(m);
            return MethodHandles.publicLookup().unreflect(m);
        }
        catch (Throwable e) {
            log.debug("Failed to access sun.nio.ch API", e);
            return null;
        }
    }

    private static int getFieldValue(String cls, String name) {
        try {
            Field f = Class.forName(cls).getDeclaredField(name);
            return JavaInternals.unsafe.getShort(JavaInternals.unsafe.staticFieldBase(f), JavaInternals.unsafe.staticFieldOffset(f));
        }
        catch (Throwable e) {
            log.debug("Failed to access sun.nio.ch API", e);
            return 0;
        }
    }

    void checkTimeout(int events, long timeout) throws IOException {
        if (timeout <= 0L || poll == null || getFD == null) {
            return;
        }
        try {
            long endTime = System.currentTimeMillis() + timeout;
            do {
                FileDescriptor fd;
                int result;
                if ((result = poll.invokeExact(fd = getFD.invoke(this.getSelectableChannel()), events, timeout)) <= 0) continue;
                return;
            } while ((timeout = endTime - System.currentTimeMillis()) > 0L);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            return;
        }
        throw new SocketTimeoutException();
    }

    public abstract SelectableChannel getSelectableChannel();
}

