/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import one.nio.mgt.Management;
import one.nio.os.Mem;
import one.nio.os.NativeLibraryMXBean;
import one.nio.os.Proc;
import one.nio.util.ByteArrayBuilder;
import one.nio.util.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NativeLibrary
implements NativeLibraryMXBean {
    private static final Logger log = LoggerFactory.getLogger(NativeLibrary.class);
    public static final boolean IS_SUPPORTED = NativeLibrary.isSupportedOs() && NativeLibrary.loadNativeLibrary();
    private final String libraryPath;

    private static boolean isSupportedOs() {
        return System.getProperty("os.name").toLowerCase().contains("linux") && System.getProperty("os.arch").contains("64");
    }

    private static boolean loadNativeLibrary() {
        try {
            InputStream in = NativeLibrary.class.getResourceAsStream("/libonenio.so");
            if (in == null) {
                log.error("Cannot find native IO library");
                return false;
            }
            ByteArrayBuilder libData = NativeLibrary.readStream(in);
            in.close();
            String tmpDir = System.getProperty("java.io.tmpdir", "/tmp");
            File dll = new File(tmpDir, "libonenio." + NativeLibrary.crc32(libData) + ".so");
            if (!dll.exists() || dll.length() != (long)libData.length() && dll.delete()) {
                FileOutputStream out = new FileOutputStream(dll);
                out.write(libData.buffer(), 0, libData.length());
                out.close();
            }
            String libraryPath = dll.getAbsolutePath();
            System.load(libraryPath);
            Management.registerMXBean(new NativeLibrary(libraryPath), "one.nio.os:type=NativeLibrary");
            return true;
        }
        catch (Throwable e) {
            log.error("Cannot load native IO library", e);
            return false;
        }
    }

    private static ByteArrayBuilder readStream(InputStream in) throws IOException {
        int bytes;
        byte[] buffer = new byte[64000];
        ByteArrayBuilder builder = new ByteArrayBuilder(buffer.length);
        while ((bytes = in.read(buffer)) > 0) {
            builder.append(buffer, 0, bytes);
        }
        return builder;
    }

    private static String crc32(ByteArrayBuilder builder) {
        CRC32 crc32 = new CRC32();
        crc32.update(builder.buffer(), 0, builder.length());
        return Hex.toHex((int)crc32.getValue());
    }

    private NativeLibrary(String libraryPath) {
        this.libraryPath = libraryPath;
    }

    @Override
    public String getLibraryPath() {
        return this.libraryPath;
    }

    @Override
    public int mlockall(int flags) {
        return Mem.mlockall(flags);
    }

    @Override
    public int munlockall() {
        return Mem.munlockall();
    }

    @Override
    public int setAffinity(int pid, long[] mask) {
        return Proc.setAffinity(pid, mask);
    }

    @Override
    public long[] getAffinity(int pid) {
        return Proc.getAffinity(pid);
    }
}

