/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.util.Map;
import one.nio.gen.BytecodeGenerator;
import one.nio.serial.EnumSerializer;
import one.nio.serial.GeneratedSerializer;
import one.nio.serial.MethodSerializer;
import one.nio.serial.Repository;
import one.nio.serial.SerializationMXBean;
import one.nio.serial.Serializer;
import one.nio.serial.SerializerNotFoundException;
import one.nio.serial.TypeDescriptor;
import one.nio.serial.gen.StubGenerator;
import one.nio.util.Hex;

class SerializationMXBeanImpl
implements SerializationMXBean {
    SerializationMXBeanImpl() {
    }

    @Override
    public String[] getClassSerializers() {
        return this.getSerializers(Repository.classMap);
    }

    @Override
    public String[] getUidSerializers() {
        return this.getSerializers(Repository.uidMap);
    }

    @Override
    public String[] getMethodSerializer() {
        return this.getSerializers(Repository.methodMap);
    }

    @Override
    public String getSerializer(String uid) {
        try {
            return Repository.requestSerializer(Hex.parseLong(uid)).toString();
        }
        catch (SerializerNotFoundException e) {
            return null;
        }
    }

    @Override
    public String getClassSerializer(String className) {
        try {
            Serializer serializer = Repository.classMap.get(Class.forName(className, false, BytecodeGenerator.INSTANCE));
            return serializer == null ? null : serializer.toString();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public byte[] getCode(String uid) {
        try {
            return Repository.requestSerializer(Hex.parseLong(uid)).code();
        }
        catch (SerializerNotFoundException e) {
            return null;
        }
    }

    @Override
    public int getOptions() {
        return Repository.getOptions();
    }

    @Override
    public void setOptions(int options) {
        Repository.setOptions(options);
    }

    @Override
    public void setOptions(String className, int options) {
        Repository.setOptions(className, options);
    }

    @Override
    public int getAnonymousClasses() {
        return Repository.anonymousClasses.get();
    }

    @Override
    public int getRenamedClasses() {
        return Repository.renamedClasses.size();
    }

    @Override
    public int getStubClasses() {
        return StubGenerator.stubClasses.get();
    }

    @Override
    public int getUnknownTypes() {
        return TypeDescriptor.unknownTypes.get();
    }

    @Override
    public int getMissedLocalFields() {
        return GeneratedSerializer.missedLocalFields.get();
    }

    @Override
    public int getMissedStreamFields() {
        return GeneratedSerializer.missedStreamFields.get();
    }

    @Override
    public int getMigratedFields() {
        return GeneratedSerializer.migratedFields.get();
    }

    @Override
    public int getRenamedFields() {
        return GeneratedSerializer.renamedFields.get();
    }

    @Override
    public int getUnsupportedFields() {
        return GeneratedSerializer.unsupportedFields.get();
    }

    @Override
    public int getEnumCountMismatches() {
        return EnumSerializer.enumCountMismatches.get();
    }

    @Override
    public int getEnumMissedConstants() {
        return EnumSerializer.enumMissedConstants.get();
    }

    @Override
    public int getRenamedMethods() {
        return MethodSerializer.renamedMethods.get();
    }

    private String[] getSerializers(Map<?, ? extends Serializer> map) {
        Serializer[] serializers = map.values().toArray(new Serializer[0]);
        String[] result = new String[serializers.length];
        int i = 0;
        for (Serializer serializer : serializers) {
            result[i++] = Long.toHexString(serializer.uid);
        }
        return result;
    }
}

