/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import one.nio.serial.Serializer;
import one.nio.util.Hash;

public class SerializedWrapper<T>
implements Serializable {
    private final byte[] serialized;

    public SerializedWrapper(byte[] serialized) {
        this.serialized = serialized;
    }

    public byte[] getSerialized() {
        return this.serialized;
    }

    public int hashCode() {
        return Hash.xxhash(this.serialized, 0, this.serialized.length);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SerializedWrapper)) {
            return false;
        }
        return Arrays.equals(this.serialized, ((SerializedWrapper)obj).serialized);
    }

    public static <T> SerializedWrapper<T> wrap(T object) throws IOException {
        return new SerializedWrapper<T>(Serializer.serialize(object));
    }

    public T unwrap() throws IOException, ClassNotFoundException {
        return (T)Serializer.deserialize(this.serialized);
    }
}

