/*
 * Decompiled with CFR 0.152.
 */
package one.nio.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import one.nio.util.JavaInternals;

public final class Utf8 {
    private static final MethodHandle compactStringConstructor = Utf8.getCompactStringConstructor();

    private static MethodHandle getCompactStringConstructor() {
        try {
            Field compactStrings = JavaInternals.getField(String.class, "COMPACT_STRINGS");
            if (compactStrings == null || !compactStrings.getBoolean(null)) {
                return null;
            }
            Constructor<String> c = JavaInternals.getConstructor(String.class, byte[].class, Byte.TYPE);
            return c == null ? null : MethodHandles.lookup().unreflectConstructor(c);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int length(String s) {
        int result = 0;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char v = s.charAt(i);
            if (v <= '\u007f' && v != '\u0000') {
                ++result;
                continue;
            }
            if (v > '\u07ff') {
                result += 3;
                continue;
            }
            result += 2;
        }
        return result;
    }

    public static int length(char[] c, int length) {
        int result = 0;
        for (int i = 0; i < length; ++i) {
            char v = c[i];
            if (v <= '\u007f' && v != '\u0000') {
                ++result;
                continue;
            }
            if (v > '\u07ff') {
                result += 3;
                continue;
            }
            result += 2;
        }
        return result;
    }

    public static int write(String s, byte[] buf, int start) {
        return Utf8.write(s, 0, s.length(), (Object)buf, JavaInternals.byteArrayOffset + (long)start);
    }

    public static int write(String s, int stringStart, int maxChars, byte[] buf, int bufferStart) {
        return Utf8.write(s, stringStart, maxChars, (Object)buf, JavaInternals.byteArrayOffset + (long)bufferStart);
    }

    public static int write(String s, Object obj, long start) {
        return Utf8.write(s, 0, s.length(), obj, start);
    }

    public static int write(String s, int inStart, int inCount, Object obj, long outStart) {
        int length = Math.min(s.length(), inStart + inCount);
        long pos = outStart;
        for (int i = inStart; i < length; ++i) {
            char v = s.charAt(i);
            if (v <= '\u007f' && v != '\u0000') {
                JavaInternals.unsafe.putByte(obj, pos++, (byte)v);
                continue;
            }
            if (v > '\u07ff') {
                JavaInternals.unsafe.putByte(obj, pos, (byte)(0xE0 | v >>> 12));
                JavaInternals.unsafe.putByte(obj, pos + 1L, (byte)(0x80 | v >>> 6 & 0x3F));
                JavaInternals.unsafe.putByte(obj, pos + 2L, (byte)(0x80 | v & 0x3F));
                pos += 3L;
                continue;
            }
            JavaInternals.unsafe.putByte(obj, pos, (byte)(0xC0 | v >>> 6));
            JavaInternals.unsafe.putByte(obj, pos + 1L, (byte)(0x80 | v & 0x3F));
            pos += 2L;
        }
        return (int)(pos - outStart);
    }

    public static int write(char[] c, int length, byte[] buf, int start) {
        return Utf8.write(c, length, (Object)buf, JavaInternals.byteArrayOffset + (long)start);
    }

    public static int write(char[] c, int length, Object obj, long start) {
        long pos = start;
        for (int i = 0; i < length; ++i) {
            char v = c[i];
            if (v <= '\u007f' && v != '\u0000') {
                JavaInternals.unsafe.putByte(obj, pos++, (byte)v);
                continue;
            }
            if (v > '\u07ff') {
                JavaInternals.unsafe.putByte(obj, pos, (byte)(0xE0 | v >>> 12));
                JavaInternals.unsafe.putByte(obj, pos + 1L, (byte)(0x80 | v >>> 6 & 0x3F));
                JavaInternals.unsafe.putByte(obj, pos + 2L, (byte)(0x80 | v & 0x3F));
                pos += 3L;
                continue;
            }
            JavaInternals.unsafe.putByte(obj, pos, (byte)(0xC0 | v >>> 6));
            JavaInternals.unsafe.putByte(obj, pos + 1L, (byte)(0x80 | v & 0x3F));
            pos += 2L;
        }
        return (int)(pos - start);
    }

    public static String read(byte[] buf, int start, int length) {
        return Utf8.read((Object)buf, JavaInternals.byteArrayOffset + (long)start, length);
    }

    public static String read(Object obj, long start, int length) {
        if (compactStringConstructor != null && Utf8.isAsciiString(obj, start, length)) {
            return Utf8.toAsciiString(obj, start, length);
        }
        char[] result = new char[length];
        int chars = 0;
        long end = start + (long)length;
        long pos = start;
        while (pos < end) {
            byte b = JavaInternals.unsafe.getByte(obj, pos);
            if (b >= 0) {
                result[chars] = (char)b;
                ++pos;
            } else if ((b & 0xE0) == 192) {
                result[chars] = (char)((b & 0x1F) << 6 | JavaInternals.unsafe.getByte(obj, pos + 1L) & 0x3F);
                pos += 2L;
            } else {
                result[chars] = (char)((b & 0xF) << 12 | (JavaInternals.unsafe.getByte(obj, pos + 1L) & 0x3F) << 6 | JavaInternals.unsafe.getByte(obj, pos + 2L) & 0x3F);
                pos += 3L;
            }
            ++chars;
        }
        return new String(result, 0, chars);
    }

    private static boolean isAsciiString(Object obj, long start, int length) {
        while (length >= 8) {
            if ((JavaInternals.unsafe.getLong(obj, start) & 0x8080808080808080L) != 0L) {
                return false;
            }
            start += 8L;
            length -= 8;
        }
        if ((length & 4) != 0) {
            if ((JavaInternals.unsafe.getInt(obj, start) & 0x80808080) != 0) {
                return false;
            }
            start += 4L;
        }
        if ((length & 2) != 0) {
            if ((JavaInternals.unsafe.getShort(obj, start) & 0x8080) != 0) {
                return false;
            }
            start += 2L;
        }
        if ((length & 1) != 0) {
            return JavaInternals.unsafe.getByte(obj, start) >= 0;
        }
        return true;
    }

    private static String toAsciiString(Object obj, long start, int length) {
        byte[] result = new byte[length];
        JavaInternals.unsafe.copyMemory(obj, start, result, JavaInternals.byteArrayOffset, length);
        try {
            return compactStringConstructor.invokeExact(result, (byte)0);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static byte[] toBytes(String s) {
        byte[] result = new byte[Utf8.length(s)];
        Utf8.write(s, (Object)result, JavaInternals.byteArrayOffset);
        return result;
    }

    public static String toString(byte[] buf) {
        return Utf8.read((Object)buf, JavaInternals.byteArrayOffset, buf.length);
    }

    public static int indexOf(byte c, byte[] haystack) {
        return Utf8.indexOf(c, haystack, 0, haystack.length);
    }

    public static int indexOf(byte c, byte[] haystack, int offset, int length) {
        while (length-- > 0) {
            if (haystack[offset] == c) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public static int indexOf(byte[] needle, byte[] haystack) {
        return Utf8.indexOf(needle, haystack, 0, haystack.length);
    }

    public static int indexOf(byte[] needle, byte[] haystack, int offset, int length) {
        if (needle.length == 0) {
            return offset;
        }
        byte first = needle[0];
        length -= needle.length;
        while (length-- >= 0) {
            block5: {
                if (haystack[offset] == first) {
                    for (int i = 1; i < needle.length; ++i) {
                        if (needle[i] == haystack[offset + i]) {
                            continue;
                        }
                        break block5;
                    }
                    return offset;
                }
            }
            ++offset;
        }
        return -1;
    }

    public static boolean startsWith(byte[] fragment, byte[] buf) {
        return buf.length >= fragment.length && Utf8.startsWith(fragment, buf, 0);
    }

    public static boolean startsWith(byte[] fragment, byte[] buf, int offset, int length) {
        return length >= fragment.length && offset + length <= buf.length && Utf8.startsWith(fragment, buf, offset);
    }

    public static boolean startsWith(byte[] fragment, byte[] buf, int offset) {
        int i = 0;
        while (i < fragment.length) {
            if (fragment[i] != buf[offset]) {
                return false;
            }
            ++i;
            ++offset;
        }
        return true;
    }

    public static long parseLong(byte[] buf) {
        return Utf8.parseLong(buf, 0, buf.length);
    }

    public static long parseLong(byte[] buf, int offset, int length) {
        boolean minus;
        if (length <= 0) {
            throw new NumberFormatException();
        }
        boolean bl = minus = buf[offset] == 45 && length > 1;
        if (minus) {
            ++offset;
            --length;
        }
        long result = 0L;
        do {
            int digit;
            if ((digit = buf[offset] - 48) < 0 || digit > 9) {
                throw new NumberFormatException();
            }
            result = result * 10L + (long)digit;
            ++offset;
        } while (--length > 0);
        return minus ? -result : result;
    }
}

