/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import one.nio.mem.DirectMemory;
import one.nio.mem.OutOfMemoryException;
import one.nio.util.JavaInternals;
import sun.misc.Unsafe;

public class LongHashSet {
    protected static final Unsafe unsafe = JavaInternals.unsafe;
    protected static final long sizeOffset = JavaInternals.fieldOffset(LongHashSet.class, "size");
    public static final long EMPTY = 0L;
    public static final long REMOVED = Long.MIN_VALUE;
    protected volatile int size;
    protected int capacity;
    protected int maxSteps;
    protected long keys;

    public LongHashSet(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be positive");
        }
        this.capacity = capacity;
        this.maxSteps = (int)Math.sqrt(capacity);
        this.keys = DirectMemory.allocateAndClear(LongHashSet.sizeInBytes(capacity), this);
    }

    public LongHashSet(int capacity, long keys) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be positive");
        }
        this.capacity = capacity;
        this.maxSteps = (int)Math.sqrt(capacity);
        this.keys = keys;
        this.size = this.calculateSize();
    }

    public final int size() {
        return this.size;
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int getKey(long key) {
        int step = 1;
        int index = LongHashSet.hash(key) % this.capacity;
        do {
            long cur;
            if ((cur = this.keyAt(index)) == key) {
                return index;
            }
            if (cur == 0L) {
                return -1;
            }
            if ((index += step) < this.capacity) continue;
            index -= this.capacity;
        } while (++step <= this.maxSteps);
        return -1;
    }

    public final int putKey(long key) {
        int step = 1;
        int index = LongHashSet.hash(key) % this.capacity;
        do {
            long cur;
            if ((cur = this.keyAt(index)) == 0L) {
                if (!unsafe.compareAndSwapLong(null, this.keys + (long)index * 8L, cur, key)) continue;
                this.incrementSize();
                return index;
            }
            if (cur == key) {
                return index;
            }
            if ((index += step) < this.capacity) continue;
            index -= this.capacity;
        } while (++step <= this.maxSteps);
        throw new OutOfMemoryException("No room for a new key");
    }

    public final int removeKey(long key) {
        int index = this.getKey(key);
        if (index >= 0 && unsafe.compareAndSwapLong(null, this.keys + (long)index * 8L, key, Long.MIN_VALUE)) {
            this.decrementSize();
            return index;
        }
        return -1;
    }

    public final long keyAt(int index) {
        return unsafe.getLongVolatile(null, this.keys + (long)index * 8L);
    }

    public final void setKeyAt(int index, long value) {
        unsafe.putOrderedLong(null, this.keys + (long)index * 8L, value);
    }

    public void clear() {
        int current;
        int sizeBefore = this.size;
        unsafe.setMemory(this.keys, (long)this.capacity * 8L, (byte)0);
        while (!unsafe.compareAndSwapInt(this, sizeOffset, current = this.size, Math.max(0, current - sizeBefore))) {
        }
    }

    protected void incrementSize() {
        int current;
        while (!unsafe.compareAndSwapInt(this, sizeOffset, current = this.size, current + 1)) {
        }
    }

    protected void decrementSize() {
        int current;
        while (!unsafe.compareAndSwapInt(this, sizeOffset, current = this.size, current - 1)) {
        }
    }

    private int calculateSize() {
        int result = 0;
        for (int i = 0; i < this.capacity; ++i) {
            long cur = this.keyAt(i);
            if (cur == 0L || cur == Long.MIN_VALUE) continue;
            ++result;
        }
        return result;
    }

    protected static int hash(long key) {
        return ((int)key ^ (int)(key >>> 21) ^ (int)(key >>> 42)) & Integer.MAX_VALUE;
    }

    public static long sizeInBytes(int capacity) {
        return (long)capacity * 8L;
    }
}

