/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.net.ssl.SSLSocket;
import one.nio.mem.DirectMemory;
import one.nio.net.JavaSslClientContext;
import one.nio.net.Msg;
import one.nio.net.Socket;
import one.nio.net.SocketClosedException;
import one.nio.net.SslContext;
import one.nio.net.SslOption;

public final class JavaSslClientSocket
extends Socket {
    private final SSLSocket socket;
    private final JavaSslClientContext sslContext;
    private volatile WritableByteChannel outCh;
    private volatile ReadableByteChannel inCh;
    private volatile OutputStream outputStream;
    private volatile InputStream inputStream;

    public JavaSslClientSocket(JavaSslClientContext sslContext) {
        try {
            this.sslContext = sslContext;
            this.socket = this.sslContext.createSocket();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Socket accept() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connect(InetAddress address, int port) throws IOException {
        this.socket.connect(new InetSocketAddress(address, port));
        this.outputStream = this.socket.getOutputStream();
        this.outCh = Channels.newChannel(this.outputStream);
        this.inputStream = this.socket.getInputStream();
        this.inCh = Channels.newChannel(this.inputStream);
    }

    @Override
    public void bind(InetAddress address, int port, int backlog) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int writeRaw(long buf, int count, int flags) throws IOException {
        return this.outCh.write(DirectMemory.wrap(buf, count));
    }

    @Override
    public int write(byte[] data, int offset, int count, int flags) throws IOException {
        return this.outCh.write(ByteBuffer.wrap(data, offset, count));
    }

    @Override
    public void writeFully(byte[] data, int offset, int count) throws IOException {
        this.outputStream.write(data, offset, count);
    }

    @Override
    public int send(ByteBuffer src, int flags, InetAddress address, int port) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readRaw(long buf, int count, int flags) throws IOException {
        return this.inCh.read(DirectMemory.wrap(buf, count));
    }

    @Override
    public int read(byte[] data, int offset, int count, int flags) throws IOException {
        return this.inCh.read(ByteBuffer.wrap(data, offset, count));
    }

    @Override
    public void readFully(byte[] data, int offset, int count) throws IOException {
        while (count > 0) {
            int bytes = this.inputStream.read(data, offset, count);
            if (bytes < 0) {
                throw new SocketClosedException();
            }
            offset += bytes;
            count -= bytes;
        }
    }

    @Override
    public long sendFile(RandomAccessFile file, long offset, long count) throws IOException {
        return file.getChannel().transferTo(offset, count, this.outCh);
    }

    @Override
    public InetSocketAddress recv(ByteBuffer dst, int flags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int sendMsg(Msg msg, int flags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int recvMsg(Msg msg, int flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlocking(boolean blocking) {
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public void setTimeout(int timeout) {
        try {
            this.socket.setSoTimeout(timeout);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public int getTimeout() {
        try {
            return this.socket.getSoTimeout();
        }
        catch (SocketException e) {
            return 0;
        }
    }

    @Override
    public void setKeepAlive(boolean keepAlive) {
        try {
            this.socket.setKeepAlive(keepAlive);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public boolean getKeepAlive() {
        try {
            return this.socket.getKeepAlive();
        }
        catch (SocketException e) {
            return false;
        }
    }

    @Override
    public void setNoDelay(boolean noDelay) {
        try {
            this.socket.setTcpNoDelay(noDelay);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public boolean getNoDelay() {
        try {
            return this.socket.getTcpNoDelay();
        }
        catch (SocketException e) {
            return false;
        }
    }

    @Override
    public void setTcpFastOpen(boolean tcpFastOpen) {
    }

    @Override
    public boolean getTcpFastOpen() {
        return false;
    }

    @Override
    public void setDeferAccept(boolean deferAccept) {
    }

    @Override
    public boolean getDeferAccept() {
        return false;
    }

    @Override
    public void setReuseAddr(boolean reuseAddr, boolean reusePort) {
        try {
            this.socket.setReuseAddress(reuseAddr);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public boolean getReuseAddr() {
        try {
            return this.socket.getReuseAddress();
        }
        catch (SocketException e) {
            return false;
        }
    }

    @Override
    public boolean getReusePort() {
        return false;
    }

    @Override
    public void setRecvBuffer(int recvBuf) {
        try {
            this.socket.setReceiveBufferSize(recvBuf);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public int getRecvBuffer() {
        try {
            return this.socket.getReceiveBufferSize();
        }
        catch (SocketException e) {
            return 0;
        }
    }

    @Override
    public void setSendBuffer(int sendBuf) {
        try {
            this.socket.setSendBufferSize(sendBuf);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public int getSendBuffer() {
        try {
            return this.socket.getSendBufferSize();
        }
        catch (SocketException e) {
            return 0;
        }
    }

    @Override
    public void setTos(int tos) {
    }

    @Override
    public int getTos() {
        return 0;
    }

    @Override
    public byte[] getOption(int level, int option) {
        return new byte[0];
    }

    @Override
    public boolean setOption(int level, int option, byte[] value) {
        return false;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return new InetSocketAddress(this.socket.getLocalAddress(), this.socket.getPort());
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    @Override
    public Socket sslWrap(SslContext context) {
        return this;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.inCh.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.outCh.write(src);
    }

    @Override
    public Socket sslUnwrap() {
        return this;
    }

    @Override
    public SslContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public <T> T getSslOption(SslOption<T> option) {
        return null;
    }

    @Override
    public void listen(int backlog) throws IOException {
        throw new UnsupportedOperationException();
    }
}

