/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.IOException;
import one.nio.net.NativeSocket;
import one.nio.net.NativeSslContext;
import one.nio.net.Socket;
import one.nio.net.SslContext;
import one.nio.net.SslOption;

class NativeSslSocket
extends NativeSocket {
    NativeSslContext context;
    long ssl;
    private volatile boolean isEarlyDataAccepted = false;
    private volatile boolean isHandshakeDone = false;

    NativeSslSocket(int fd, NativeSslContext context, boolean serverMode) throws IOException {
        super(fd);
        context.refresh();
        this.context = context;
        this.ssl = NativeSslSocket.sslNew(fd, context.ctx, serverMode);
    }

    @Override
    public synchronized void close() {
        if (this.ssl != 0L) {
            NativeSslSocket.sslFree(this.ssl);
            this.ssl = 0L;
        }
        super.close();
    }

    @Override
    public NativeSocket accept() throws IOException {
        int fd = this.accept0(false);
        return fd >= 0 ? new NativeSslSocket(fd, this.context, true) : null;
    }

    @Override
    public NativeSocket acceptNonBlocking() throws IOException {
        int fd = this.accept0(true);
        return fd >= 0 ? new NativeSslSocket(fd, this.context, true) : null;
    }

    @Override
    public Socket sslUnwrap() {
        return new NativeSocket(this.fd);
    }

    @Override
    public SslContext getSslContext() {
        return this.context;
    }

    public Object getSslOption(SslOption option) {
        switch (option.id) {
            case 1: {
                return this.sslPeerCertificate();
            }
            case 2: {
                return this.sslPeerCertificateChain();
            }
            case 3: {
                return this.sslCertName(0);
            }
            case 4: {
                return this.sslCertName(1);
            }
            case 5: {
                return this.sslVerifyResult();
            }
            case 6: {
                return this.sslSessionReused();
            }
            case 7: {
                return this.sslSessionTicket();
            }
            case 8: {
                return this.sslCurrentCipher();
            }
            case 9: {
                return this.sslSessionEarlyDataAccepted();
            }
            case 10: {
                return this.sslHandshakeDone();
            }
        }
        return null;
    }

    @Override
    public synchronized native void handshake() throws IOException;

    @Override
    public synchronized native int writeRaw(long var1, int var3, int var4) throws IOException;

    @Override
    public synchronized native int write(byte[] var1, int var2, int var3, int var4) throws IOException;

    @Override
    public synchronized native void writeFully(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public synchronized native int readRaw(long var1, int var3, int var4) throws IOException;

    @Override
    public synchronized native int read(byte[] var1, int var2, int var3, int var4) throws IOException;

    @Override
    public synchronized native void readFully(byte[] var1, int var2, int var3) throws IOException;

    @Override
    synchronized native long sendFile0(int var1, long var2, long var4) throws IOException;

    private boolean sslSessionEarlyDataAccepted() {
        return this.isEarlyDataAccepted;
    }

    private boolean sslHandshakeDone() {
        return this.isHandshakeDone;
    }

    private synchronized native byte[] sslPeerCertificate();

    private synchronized native Object[] sslPeerCertificateChain();

    private synchronized native String sslCertName(int var1);

    private synchronized native String sslVerifyResult();

    private synchronized native boolean sslSessionReused();

    private synchronized native int sslSessionTicket();

    private synchronized native String sslCurrentCipher();

    static native long sslNew(int var0, long var1, boolean var3) throws IOException;

    static native void sslFree(long var0);
}

