/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLException;
import one.nio.net.NativeSslContext;
import one.nio.net.SslConfig;
import one.nio.os.NativeLibrary;
import one.nio.util.ByteArrayBuilder;
import one.nio.util.Utf8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SslContext {
    private static final Logger log = LoggerFactory.getLogger(SslContext.class);
    public static final int VERIFY_NONE = 0;
    public static final int VERIFY_PEER = 1;
    public static final int VERIFY_REQUIRE_PEER_CERT = 2;
    public static final int VERIFY_ONCE = 4;
    private final AtomicLong nextRefresh = new AtomicLong();
    private long lastCertUpdate;
    private long lastTicketsUpdate;
    private long lastOCSPUpdate;
    protected SslConfig currentConfig = new SslConfig();

    public static SslContext getDefault() {
        return NativeLibrary.IS_SUPPORTED ? NativeSslContext.Holder.DEFAULT : null;
    }

    public static SslContext create() throws SSLException {
        if (NativeLibrary.IS_SUPPORTED) {
            return new NativeSslContext();
        }
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    public synchronized SslContext configure(SslConfig config) throws IOException {
        if (config.verifyMode != 0 && config.sessionId == null) {
            throw new SSLException("SessionId should be provided if verifyMode is set");
        }
        this.setDebug(config.debug);
        if (config.rdrand != this.currentConfig.rdrand) {
            this.setRdrand(config.rdrand);
        }
        if (SslContext.changed(config.protocols, this.currentConfig.protocols)) {
            this.setProtocols(config.protocols);
        }
        this.setCiphers(config.ciphers != null ? config.ciphers : "ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-CHACHA20-POLY1305:ECDHE-RSA-CHACHA20-POLY1305:DHE-RSA-AES128-GCM-SHA256:DHE-RSA-AES256-GCM-SHA384:DHE-RSA-CHACHA20-POLY1305:ECDHE-ECDSA-AES128-SHA256:ECDHE-RSA-AES128-SHA256:ECDHE-ECDSA-AES128-SHA:ECDHE-RSA-AES128-SHA:ECDHE-ECDSA-AES256-SHA384:ECDHE-RSA-AES256-SHA384:ECDHE-ECDSA-AES256-SHA:ECDHE-RSA-AES256-SHA:DHE-RSA-AES128-SHA256:DHE-RSA-AES256-SHA256:AES128-GCM-SHA256:AES256-GCM-SHA384:AES128-SHA256:AES256-SHA256:AES128-SHA:AES256-SHA:DES-CBC3-SHA");
        this.setCurve(config.curve);
        if (SslContext.changed(config.passphrase, this.currentConfig.passphrase)) {
            this.setPassphrase(Utf8.toBytes(this.getPassphrase(config.passphrase)));
        }
        if (SslContext.changed(config.certFile, this.currentConfig.certFile)) {
            long lastCertUpdate = 0L;
            for (String certFile : config.certFile) {
                this.setCertificate(certFile);
                lastCertUpdate = Math.max(lastCertUpdate, new File(certFile).lastModified());
            }
            this.lastCertUpdate = lastCertUpdate;
        }
        if (SslContext.changed(config.privateKeyFile, this.currentConfig.privateKeyFile)) {
            for (String privateKeyFile : config.privateKeyFile) {
                this.setPrivateKey(privateKeyFile);
            }
        }
        if (SslContext.changed(config.caFile, this.currentConfig.caFile)) {
            this.setCA(config.caFile);
        }
        if (SslContext.changed(config.ticketDir, this.currentConfig.ticketDir)) {
            this.updateTicketKeys(config.ticketDir, true);
        } else if (SslContext.changed(config.ticketKeyFile, this.currentConfig.ticketKeyFile)) {
            this.setTicketKeys(Files.readAllBytes(Paths.get(config.ticketKeyFile, new String[0])));
        } else if (config.ticketDir == null && config.ticketKeyFile == null) {
            this.setTicketKeys(null);
        }
        this.setVerify(config.verifyMode);
        this.setSessionCache(config.cacheMode, config.cacheSize != 0 ? config.cacheSize : 262144);
        this.setTimeout(config.timeout != 0L ? config.timeout / 1000L : 300L);
        this.setMaxEarlyData(config.maxEarlyDataSize);
        if (config.maxEarlyDataSize > 0) {
            this.setAntiReplayEnabled(config.antiReplayEnabled);
        }
        this.setKernelTlsEnabled(config.kernelTlsEnabled);
        if (SslContext.changed(config.sessionId, this.currentConfig.sessionId)) {
            this.setSessionId(Utf8.toBytes(config.sessionId));
        }
        if (SslContext.changed(config.applicationProtocols, this.currentConfig.applicationProtocols)) {
            this.setApplicationProtocols(config.applicationProtocols);
        }
        if (SslContext.changed(config.ocspFile, this.currentConfig.ocspFile)) {
            this.updateOCSP(config.ocspFile, true);
        } else if (config.ocspFile == null) {
            this.setOCSP(null);
        }
        if (config.sni != this.currentConfig.sni) {
            this.inherit(config, config.sni);
            this.setSNI(config.sni);
        }
        if (config.compressionAlgorithms != this.currentConfig.compressionAlgorithms) {
            this.setCompressionAlgorithms(config.compressionAlgorithms);
        }
        if (config.keylog != this.currentConfig.keylog) {
            this.setKeylog(config.keylog);
        }
        this.currentConfig = config;
        return this;
    }

    private static boolean changed(String newValue, String currentValue) {
        return newValue != null && !newValue.equals(currentValue);
    }

    private static boolean changed(String[] newValue, String[] currentValue) {
        return newValue != null && !Arrays.equals(newValue, currentValue);
    }

    private String getPassphrase(String passphrase) {
        String envPassphrase;
        int length = passphrase.length();
        if (length > 2 && passphrase.charAt(0) == '%' && passphrase.charAt(length - 1) == '%' && (envPassphrase = System.getenv(passphrase.substring(1, length - 1))) != null) {
            return envPassphrase;
        }
        return passphrase;
    }

    private void inherit(SslConfig parent, SslConfig[] children) {
        if (children != null) {
            for (SslConfig child : children) {
                for (Field f : SslConfig.class.getFields()) {
                    try {
                        Object value = f.get(child);
                        if (value != null && value != Boolean.FALSE && (!(value instanceof Number) || ((Number)value).longValue() != 0L)) continue;
                        f.set(child, f.get(parent));
                    }
                    catch (IllegalAccessException e) {
                        throw new AssertionError((Object)"Should not happen");
                    }
                }
            }
        }
    }

    void updateCertificates(String[] certFiles, String[] privateKeyFiles) throws IOException {
        long maxLastModified = 0L;
        for (String certFile : certFiles) {
            long lastModified = new File(certFile).lastModified();
            if (lastModified <= this.lastCertUpdate) continue;
            this.setCertificate(certFile);
            maxLastModified = Math.max(maxLastModified, lastModified);
        }
        if (maxLastModified == 0L) {
            return;
        }
        for (String privateKeyFile : privateKeyFiles) {
            this.setPrivateKey(privateKeyFile);
        }
        log.info("Certificates updated: {}", (Object)new Date(maxLastModified));
        this.lastCertUpdate = maxLastModified;
    }

    void updateTicketKeys(String ticketDir, boolean force) throws IOException {
        File[] files = new File(ticketDir).listFiles();
        if (files == null || files.length == 0) {
            log.warn("No ticket keys found in {}", (Object)ticketDir);
            return;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File a, File b) {
                return Long.compare(b.lastModified(), a.lastModified());
            }
        });
        long lastModified = files[0].lastModified();
        if (force || lastModified > this.lastTicketsUpdate) {
            ByteArrayBuilder builder = new ByteArrayBuilder(files.length * 48);
            for (File file : files) {
                byte[] data = Files.readAllBytes(file.toPath());
                builder.append(data);
            }
            this.setTicketKeys(builder.trim());
            log.info("Ticket keys updated: {}, key count = {}", (Object)new Date(lastModified), (Object)files.length);
            this.lastTicketsUpdate = lastModified;
        }
    }

    void updateOCSP(String ocspFile, boolean force) throws IOException {
        long lastModified = new File(ocspFile).lastModified();
        if (force || lastModified > this.lastOCSPUpdate) {
            this.setOCSP(Files.readAllBytes(Paths.get(ocspFile, new String[0])));
            log.info("OCSP updated: {}", (Object)new Date(lastModified));
            this.lastOCSPUpdate = lastModified;
        }
    }

    void refresh() {
        long refreshTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime < (refreshTime = this.nextRefresh.get())) {
            return;
        }
        long refreshInterval = this.currentConfig.refreshInterval;
        if (refreshInterval == 0L) {
            refreshInterval = 300000L;
        }
        if (!this.nextRefresh.compareAndSet(refreshTime, currentTime + refreshInterval)) {
            return;
        }
        if (this.currentConfig.certFile != null && this.currentConfig.privateKeyFile != null) {
            try {
                this.updateCertificates(this.currentConfig.certFile, this.currentConfig.privateKeyFile);
            }
            catch (IOException e) {
                log.error("Failed to update certificates", (Throwable)e);
            }
        }
        if (this.currentConfig.ticketDir != null) {
            try {
                this.updateTicketKeys(this.currentConfig.ticketDir, false);
            }
            catch (IOException e) {
                log.error("Failed to update ticket keys", (Throwable)e);
            }
        }
        if (this.currentConfig.ocspFile != null) {
            try {
                this.updateOCSP(this.currentConfig.ocspFile, false);
            }
            catch (IOException e) {
                log.error("Failed to update OCSP", (Throwable)e);
            }
        }
    }

    public abstract void setDebug(boolean var1);

    public abstract boolean getDebug();

    public abstract void setRdrand(boolean var1) throws SSLException;

    public abstract void setProtocols(String var1) throws SSLException;

    public abstract void setCiphers(String var1) throws SSLException;

    public abstract void setCurve(String var1) throws SSLException;

    public abstract void setCertificate(String var1) throws SSLException;

    public abstract void setPrivateKey(String var1) throws SSLException;

    public abstract void setPassphrase(byte[] var1) throws SSLException;

    public abstract void setCA(String var1) throws SSLException;

    public abstract void setVerify(int var1) throws SSLException;

    public abstract void setTicketKeys(byte[] var1) throws SSLException;

    public abstract void setSessionCache(String var1, int var2) throws SSLException;

    public abstract void setTimeout(long var1) throws SSLException;

    public abstract void setSessionId(byte[] var1) throws SSLException;

    public abstract void setApplicationProtocols(String[] var1) throws SSLException;

    public abstract void setOCSP(byte[] var1) throws SSLException;

    public abstract void setSNI(SslConfig[] var1) throws IOException;

    public abstract void setMaxEarlyData(int var1) throws SSLException;

    public abstract void setKernelTlsEnabled(boolean var1) throws SSLException;

    public abstract void setCompressionAlgorithms(String[] var1) throws SSLException;

    public abstract void setAntiReplayEnabled(boolean var1) throws SSLException;

    public abstract void setKeylog(boolean var1);
}

