/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server;

import java.util.Locale;
import one.nio.config.Config;
import one.nio.config.Converter;
import one.nio.net.ConnectionString;
import one.nio.net.SslConfig;
import one.nio.os.SchedulingPolicy;
import one.nio.server.AcceptorConfig;

@Config
public class ServerConfig {
    public static String DEFAULT_SELECTOR_THREAD_NAME_FORMAT = "NIO Selector #%d";
    public AcceptorConfig[] acceptors;
    public boolean multiAcceptor;
    public int selectors;
    public boolean affinity;
    public int minWorkers;
    public int maxWorkers;
    @Converter(method="time")
    public @Converter(method="time") int queueTime;
    @Converter(method="time")
    public @Converter(method="time") int keepAlive;
    public int threadPriority = 5;
    public SchedulingPolicy schedulingPolicy;
    public boolean closeSessions;
    public boolean pinAcceptors;
    @Converter(value=ServerConfig.class, method="threadNameFormat")
    public @Converter(value=ServerConfig.class, method="threadNameFormat") String selectorThreadNameFormat = DEFAULT_SELECTOR_THREAD_NAME_FORMAT;

    public ServerConfig() {
    }

    private ServerConfig(ConnectionString conn) {
        AcceptorConfig ac = new AcceptorConfig();
        ac.address = conn.getHost();
        ac.port = conn.getPort();
        ac.recvBuf = conn.getIntParam("recvBuf", 0);
        ac.sendBuf = conn.getIntParam("sendBuf", 0);
        ac.tos = conn.getIntParam("tos", 0);
        ac.backlog = conn.getIntParam("backlog", 128);
        if ("ssl".equals(conn.getProtocol())) {
            ac.ssl = SslConfig.from(System.getProperties());
        }
        this.acceptors = new AcceptorConfig[]{ac};
        this.selectors = conn.getIntParam("selectors", 0);
        this.minWorkers = conn.getIntParam("minWorkers", 0);
        this.maxWorkers = conn.getIntParam("maxWorkers", 0);
        this.queueTime = conn.getIntParam("queueTime", 0) / 1000;
        this.threadPriority = conn.getIntParam("threadPriority", 5);
        this.schedulingPolicy = SchedulingPolicy.valueOf(conn.getStringParam("schedulingPolicy", "OTHER"));
        this.closeSessions = conn.getBooleanParam("closeSessions", false);
        this.keepAlive = conn.getIntParam("keepAlive", 0);
        this.selectorThreadNameFormat = ServerConfig.threadNameFormat(conn.getStringParam("selectorThreadNameFormat", DEFAULT_SELECTOR_THREAD_NAME_FORMAT));
    }

    public static ServerConfig from(String conn) {
        return new ServerConfig(new ConnectionString(conn));
    }

    public static ServerConfig from(ConnectionString conn) {
        return new ServerConfig(conn);
    }

    public String formatSelectorThreadName(int threadNumber) {
        return String.format(Locale.ROOT, this.selectorThreadNameFormat, threadNumber);
    }

    public static String threadNameFormat(String s) {
        String.format(Locale.ROOT, s, 0);
        return s;
    }
}

