/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server.acceptor;

import java.io.IOException;
import one.nio.server.AcceptorConfig;
import one.nio.server.Server;
import one.nio.server.ServerConfig;
import one.nio.server.acceptor.Acceptor;
import one.nio.server.acceptor.DefaultAcceptor;
import one.nio.server.acceptor.MultiAcceptor;

public abstract class AcceptorFactory {
    private AcceptorFactory() {
    }

    public abstract Acceptor create(Server var1, AcceptorConfig ... var2) throws IOException;

    public static AcceptorFactory get(ServerConfig sc) {
        if (sc.multiAcceptor) {
            return MultiAcceptorFactory.INSTANCE;
        }
        return DefaultAcceptorFactory.INSTANCE;
    }

    private static class MultiAcceptorFactory
    extends AcceptorFactory {
        private static final MultiAcceptorFactory INSTANCE = new MultiAcceptorFactory();

        private MultiAcceptorFactory() {
        }

        @Override
        public Acceptor create(Server s, AcceptorConfig ... configs) throws IOException {
            return new MultiAcceptor(s, configs);
        }
    }

    private static class DefaultAcceptorFactory
    extends AcceptorFactory {
        private static final DefaultAcceptorFactory INSTANCE = new DefaultAcceptorFactory();

        private DefaultAcceptorFactory() {
        }

        @Override
        public Acceptor create(Server s, AcceptorConfig ... configs) throws IOException {
            return new DefaultAcceptor(s, configs);
        }
    }
}

