/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server.acceptor;

import java.io.IOException;
import java.util.Arrays;
import one.nio.server.AcceptorConfig;
import one.nio.server.Server;
import one.nio.server.acceptor.Acceptor;
import one.nio.server.acceptor.DefaultAcceptorGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAcceptor
implements Acceptor {
    private static final Logger log = LoggerFactory.getLogger(DefaultAcceptor.class);
    private final Server server;
    private volatile DefaultAcceptorGroup[] acceptorGroups;

    DefaultAcceptor(Server server, AcceptorConfig ... configs) throws IOException {
        this.server = server;
        DefaultAcceptorGroup[] acceptorGroups = new DefaultAcceptorGroup[configs.length];
        for (int configIdx = 0; configIdx < configs.length; ++configIdx) {
            AcceptorConfig config = configs[configIdx];
            acceptorGroups[configIdx] = new DefaultAcceptorGroup(server, config);
        }
        this.acceptorGroups = acceptorGroups;
    }

    @Override
    public void reconfigure(AcceptorConfig ... configs) throws IOException {
        DefaultAcceptorGroup[] oldAcceptorGroups = (DefaultAcceptorGroup[])this.acceptorGroups.clone();
        DefaultAcceptorGroup[] newAcceptorGroups = new DefaultAcceptorGroup[configs.length];
        for (int configIdx = 0; configIdx < configs.length; ++configIdx) {
            DefaultAcceptorGroup oldGroup;
            AcceptorConfig ac = configs[configIdx];
            DefaultAcceptorGroup defaultAcceptorGroup = oldGroup = configIdx < oldAcceptorGroups.length ? oldAcceptorGroups[configIdx] : null;
            if (oldGroup != null && oldGroup.isSameAddressPort(ac)) {
                log.info("Reconfiguring acceptor group: {}", (Object)oldGroup);
                oldGroup.reconfigure(ac);
                newAcceptorGroups[configIdx] = oldGroup;
                oldAcceptorGroups[configIdx] = null;
                continue;
            }
            DefaultAcceptorGroup newGroup = new DefaultAcceptorGroup(this.server, ac);
            log.info("New acceptor group: {}", (Object)newGroup);
            newAcceptorGroups[configIdx] = newGroup;
            newGroup.start();
        }
        for (DefaultAcceptorGroup oldGroup : oldAcceptorGroups) {
            if (oldGroup == null) continue;
            log.info("Stopping acceptor group: {}", (Object)oldGroup);
            oldGroup.shutdown();
        }
        this.acceptorGroups = newAcceptorGroups;
    }

    @Override
    public void start() {
        for (DefaultAcceptorGroup acceptorGroup : this.acceptorGroups) {
            acceptorGroup.start();
        }
    }

    @Override
    public void shutdown() {
        for (DefaultAcceptorGroup acceptorGroup : this.acceptorGroups) {
            acceptorGroup.shutdown();
        }
    }

    @Override
    public void syncStart() throws InterruptedException {
        for (DefaultAcceptorGroup acceptorGroup : this.acceptorGroups) {
            acceptorGroup.syncStart();
        }
    }

    @Override
    public long getAcceptedSessions() {
        return Arrays.stream(this.acceptorGroups).mapToLong(DefaultAcceptorGroup::getAcceptedSessions).sum();
    }

    @Override
    public long getRejectedSessions() {
        return Arrays.stream(this.acceptorGroups).mapToLong(DefaultAcceptorGroup::getRejectedSessions).sum();
    }

    @Override
    public void resetCounters() {
        for (DefaultAcceptorGroup acceptorGroup : this.acceptorGroups) {
            acceptorGroup.resetCounters();
        }
    }

    @Override
    public int getSinglePort() {
        return this.acceptorGroups[0].getPort();
    }
}

