/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server.acceptor;

import java.io.IOException;
import one.nio.net.Selector;
import one.nio.net.Session;
import one.nio.net.Socket;
import one.nio.os.NativeLibrary;
import one.nio.server.AcceptorConfig;
import one.nio.server.acceptor.AcceptorSupport;
import one.nio.server.acceptor.MultiAcceptorGroup;

class MultiAcceptSession
extends Session {
    final int backlog;
    final MultiAcceptorGroup group;
    final int idx;

    MultiAcceptSession(Socket socket, int backlog, MultiAcceptorGroup group, int idx) {
        super(socket, MultiAcceptSession.acceptOp());
        this.backlog = backlog;
        this.group = group;
        this.idx = idx;
    }

    void listen(Selector selector) throws IOException {
        this.socket.listen(this.backlog);
        selector.register(this);
    }

    public void reconfigure(AcceptorConfig newConfig) throws IOException {
        AcceptorSupport.reconfigureSocket(this.socket, newConfig);
    }

    static int acceptOp() {
        return NativeLibrary.IS_SUPPORTED ? 1 : 16;
    }
}

