/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server.acceptor;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.RejectedExecutionException;
import one.nio.net.Selector;
import one.nio.net.Session;
import one.nio.net.Socket;
import one.nio.server.Server;
import one.nio.server.acceptor.MultiAcceptSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MultiAcceptorThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(MultiAcceptorThread.class);
    private static final int MAX_ACCEPTED_PER_SOCKET = 128;
    private final Server server;
    private final Selector selector;
    volatile long acceptedSessions;
    volatile long rejectedSessions;

    MultiAcceptorThread(Server server) throws IOException {
        this.server = server;
        this.selector = Selector.create();
    }

    void register(MultiAcceptSession session) throws IOException {
        session.listen(this.selector);
    }

    @Override
    public void run() {
        block8: {
            Socket clientSocket = null;
            try {
                while (!Thread.currentThread().isInterrupted() && this.selector.isOpen()) {
                    Iterator<Session> it = this.selector.select();
                    while (it.hasNext()) {
                        MultiAcceptSession as = (MultiAcceptSession)it.next();
                        int accepted = 0;
                        while (accepted < 128 && (clientSocket = as.socket().acceptNonBlocking()) != null) {
                            try {
                                Session clientSession = this.server.createSession(clientSocket);
                                this.server.register(clientSession, as.idx, as.group.size());
                                clientSocket = null;
                                ++this.acceptedSessions;
                                ++accepted;
                            }
                            catch (RejectedExecutionException e) {
                                log.debug("Rejected session from {}", (Object)clientSocket.getRemoteAddress(), (Object)e);
                                ++this.rejectedSessions;
                                clientSocket.close();
                                clientSocket = null;
                            }
                        }
                    }
                }
            }
            catch (Throwable t) {
                if (this.selector.isOpen()) {
                    log.error("Cannot accept incoming connection", t);
                }
                if (clientSocket == null) break block8;
                clientSocket.close();
            }
        }
    }

    void shutdown() {
        this.selector.close();
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

