/*
 * Decompiled with CFR 0.152.
 */
package one.nio.config;

import java.util.HashMap;
import java.util.Map;

public class DefaultConverters {
    private static final Map<String, Long> TIMES = new HashMap<String, Long>();
    private static final Map<String, Long> SIZES = new HashMap<String, Long>();

    public static int time(String s) {
        return (int)DefaultConverters.longTime(s);
    }

    public static long longTime(String s) {
        return DefaultConverters.parseMultiplier(s, TIMES);
    }

    public static int size(String s) {
        return (int)DefaultConverters.longSize(s);
    }

    public static long longSize(String s) {
        return DefaultConverters.parseMultiplier(s, SIZES);
    }

    public static long parseMultiplier(String s, Map<String, Long> multipliers) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            if (s.charAt(i) <= '9') continue;
            String suffix = s.substring(i).toLowerCase();
            Long multiplier = multipliers.get(suffix);
            if (multiplier == null) {
                throw new IllegalArgumentException("Unknown suffix: " + suffix);
            }
            return Long.parseLong(s.substring(0, i)) * multiplier;
        }
        return Long.parseLong(s);
    }

    static {
        TIMES.put("ms", 1L);
        TIMES.put("s", 1000L);
        TIMES.put("m", 60000L);
        TIMES.put("h", 3600000L);
        TIMES.put("d", 86400000L);
        SIZES.put("k", 1024L);
        SIZES.put("m", 0x100000L);
        SIZES.put("g", 0x40000000L);
    }
}

