/*
 * Decompiled with CFR 0.152.
 */
package one.nio.http;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import one.nio.http.EventSource;
import one.nio.http.EventSourceResponse;
import one.nio.http.HttpException;
import one.nio.http.Request;
import one.nio.http.Response;
import one.nio.net.ConnectionString;
import one.nio.net.HttpProxy;
import one.nio.net.Socket;
import one.nio.net.SocketClosedException;
import one.nio.net.SslClientContextFactory;
import one.nio.pool.PoolException;
import one.nio.pool.SocketPool;
import one.nio.util.Utf8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
extends SocketPool {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    protected String[] permanentHeaders;
    protected int bufferSize;

    public HttpClient(ConnectionString conn) {
        this(conn, "Host: " + conn.getHost(), conn.getBooleanParam("keepalive", true) ? "Connection: Keep-Alive" : "Connection: close");
    }

    public HttpClient(ConnectionString conn, String ... permanentHeaders) {
        super(conn);
        this.permanentHeaders = permanentHeaders;
    }

    @Override
    protected void setProperties(ConnectionString conn) {
        String proxyAddr;
        boolean https = "https".equals(conn.getProtocol());
        if (https) {
            this.sslContext = SslClientContextFactory.create();
        }
        if (this.port == 0) {
            int n = this.port = https ? 443 : 80;
        }
        if ((proxyAddr = conn.getStringParam("proxy")) != null) {
            int p = proxyAddr.lastIndexOf(58);
            if (p >= 0) {
                String proxyHost = proxyAddr.substring(0, p);
                int proxyPort = Integer.parseInt(proxyAddr.substring(p + 1));
                this.setProxy(new HttpProxy(proxyHost, proxyPort));
            } else {
                this.setProxy(new HttpProxy(proxyAddr, 3128));
            }
        }
        this.bufferSize = conn.getIntParam("bufferSize", 8000);
    }

    public Response invoke(Request request) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(request, this.readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response invoke(Request request, int timeout) throws InterruptedException, PoolException, IOException, HttpException {
        int method = request.getMethod();
        byte[] rawRequest = request.toBytes();
        Socket socket = (Socket)this.borrowObject();
        boolean keepAlive = false;
        try {
            ResponseReader responseReader;
            try {
                socket.setTimeout(timeout == 0 ? this.readTimeout : timeout);
                socket.writeFully(rawRequest, 0, rawRequest.length);
                responseReader = new ResponseReader(socket, this.bufferSize);
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (IOException e) {
                this.destroyObject(socket);
                socket = this.createObject();
                socket.writeFully(rawRequest, 0, rawRequest.length);
                responseReader = new ResponseReader(socket, this.bufferSize);
            }
            Response response = responseReader.readResponse(method);
            keepAlive = !"close".equalsIgnoreCase(response.getHeader("Connection:"));
            Response response2 = response;
            return response2;
        }
        finally {
            if (keepAlive) {
                this.returnObject(socket);
            } else {
                this.invalidateObject(socket);
            }
        }
    }

    public Response get(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(1, uri, headers));
    }

    public EventSourceResponse openEvents(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.openEvents(this.createRequest(1, uri, headers), this.readTimeout);
    }

    public Response delete(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(6, uri, headers));
    }

    public Response post(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(2, uri, headers));
    }

    public Response post(String uri, byte[] body, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        Request request = this.createRequest(2, uri, headers);
        if (body != null) {
            request.addHeader("Content-Length: " + body.length);
            request.setBody(body);
        }
        return this.invoke(request);
    }

    public Response put(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(5, uri, headers));
    }

    public Response put(String uri, byte[] body, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        Request request = this.createRequest(5, uri, headers);
        if (body != null) {
            request.addHeader("Content-Length: " + body.length);
            request.setBody(body);
        }
        return this.invoke(request);
    }

    public Response patch(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(9, uri, headers));
    }

    public Response patch(String uri, byte[] body, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        Request request = this.createRequest(9, uri, headers);
        if (body != null) {
            request.addHeader("Content-Length: " + body.length);
            request.setBody(body);
        }
        return this.invoke(request);
    }

    public Response head(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(3, uri, headers));
    }

    public Response options(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(4, uri, headers));
    }

    public Response trace(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(7, uri, headers));
    }

    public Response connect(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(8, uri, headers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventSourceResponse openEvents(Request request, int timeout) throws InterruptedException, PoolException, IOException, HttpException {
        request.addHeader("Accept: text/event-stream");
        int method = request.getMethod();
        byte[] rawRequest = request.toBytes();
        Socket socket = (Socket)this.borrowObject();
        boolean open = false;
        try {
            ServerSentEventsReader sseReader;
            try {
                socket.setTimeout(timeout == 0 ? this.readTimeout : timeout);
                socket.writeFully(rawRequest, 0, rawRequest.length);
                sseReader = new ServerSentEventsReader(socket, this.bufferSize);
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (IOException e) {
                this.destroyObject(socket);
                socket = this.createObject();
                socket.setTimeout(timeout == 0 ? this.readTimeout : timeout);
                socket.writeFully(rawRequest, 0, rawRequest.length);
                sseReader = new ServerSentEventsReader(socket, this.bufferSize);
            }
            EventSourceResponse response = sseReader.readResponse(method);
            open = true;
            EventSourceResponse eventSourceResponse = response;
            return eventSourceResponse;
        }
        finally {
            if (!open) {
                this.invalidateObject(socket);
            }
        }
    }

    public EventSourceResponse reopenEvents(Request request, String lastId, int timeout) throws InterruptedException, PoolException, IOException, HttpException {
        request.addHeader("Last-Event-ID: " + lastId);
        return this.openEvents(request, timeout);
    }

    public Request createRequest(int method, String uri, String ... headers) {
        Request request = new Request(method, uri, true);
        for (String header : this.permanentHeaders) {
            request.addHeader(header);
        }
        for (String header : headers) {
            request.addHeader(header);
        }
        return request;
    }

    static class EventImpl
    implements EventSource.Event<String> {
        private String id;
        private String name;
        private String data;
        private String comment;

        EventImpl() {
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String data() {
            return this.data;
        }

        @Override
        public String comment() {
            return this.comment;
        }

        boolean with(String field, StringBuilder databuf) {
            switch (field) {
                case "id": {
                    this.id = databuf.toString();
                    break;
                }
                case "event": {
                    this.name = databuf.toString();
                    break;
                }
                case "data": {
                    this.data = databuf.toString();
                    break;
                }
                case "": {
                    this.comment = databuf.toString();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.id == null && this.name == null && this.data == null;
        }

        public String toString() {
            return this.isEmpty() ? "empty" : this.name + ":" + this.id;
        }
    }

    class ServerSentEventsReader
    extends ChunkedLineReader
    implements EventSource<String> {
        private boolean keepAlive;

        ServerSentEventsReader(Socket socket, int bufferSize) throws IOException {
            super(socket, bufferSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        EventSourceResponse readResponse(int method) throws IOException, HttpException {
            EventSourceResponse response = new EventSourceResponse(this.readResultCode());
            this.readResponseHeaders(response);
            if (response.getHeader("Content-Type: text/event-stream") == null) {
                try {
                    this.readResponseBody(method, response);
                    this.keepAlive = !"close".equalsIgnoreCase(response.getHeader("Connection:"));
                    EventSourceResponse eventSourceResponse = response;
                    return eventSourceResponse;
                }
                finally {
                    this.close();
                }
            }
            if (!"chunked".equalsIgnoreCase(response.getHeader("Transfer-Encoding:"))) {
                throw new UnsupportedOperationException("Only chunked transfer encoding is supported for text/event-stream");
            }
            response.setEventSource(this);
            return response;
        }

        @Override
        public EventSource.Event<String> poll() {
            if (!this.hasNext()) {
                return null;
            }
            String line = this.next();
            return line == null || line.isEmpty() ? null : this.readEvent(line);
        }

        private EventImpl readEvent(String line) {
            EventImpl eimpl = new EventImpl();
            StringBuilder databuf = new StringBuilder(line.length());
            String field = ":";
            try {
                do {
                    String f;
                    int cpos;
                    if ((cpos = line.indexOf(58)) == 0) {
                        f = "";
                        ++cpos;
                    } else if (cpos < 0) {
                        f = line;
                        cpos = line.length();
                    } else {
                        f = line.substring(0, cpos);
                        if (++cpos < line.length() && line.charAt(cpos) == ' ') {
                            ++cpos;
                        }
                    }
                    if (!field.equals(f)) {
                        eimpl.with(field, databuf);
                        field = f;
                        databuf.setLength(0);
                    } else {
                        databuf.append('\n');
                    }
                    databuf.append(line, cpos, line.length());
                    line = this.next();
                    if (line != null) continue;
                    return null;
                } while (!line.isEmpty());
                if (databuf.length() > 0) {
                    eimpl.with(field, databuf);
                }
            }
            catch (RuntimeException e) {
                log.error("Cannot parse line: {}", (Object)line, (Object)e);
                throw e;
            }
            log.debug("Read event from stream: {}", (Object)eimpl);
            return eimpl;
        }

        @Override
        public void close() {
            if (this.socket != null && this.keepAlive) {
                HttpClient.this.returnObject(this.socket);
                this.socket = null;
            } else {
                super.close();
            }
        }
    }

    class ChunkedLineReader
    extends ResponseReader
    implements Iterator<String>,
    Closeable {
        private byte[] ch;
        private int chPos;
        private int chLen;
        private boolean hasNext;

        ChunkedLineReader(Socket socket, int bufferSize) throws IOException {
            super(socket, bufferSize);
            this.ch = this.buf;
            this.chPos = 0;
            this.chLen = 0;
            this.hasNext = true;
        }

        private boolean nextChunk() throws IOException, HttpException {
            int contentBytes;
            String l = this.readLine();
            int chunkSize = Integer.parseInt(l.isEmpty() ? this.readLine() : l, 16);
            if (chunkSize == 0) {
                this.readLine();
                this.chPos = 0;
                this.chLen = 0;
                this.hasNext = false;
                return false;
            }
            if (chunkSize > this.ch.length) {
                this.ch = new byte[this.chunkSizeFor(chunkSize)];
            }
            if ((contentBytes = this.length - this.pos) < chunkSize) {
                System.arraycopy(this.buf, this.pos, this.ch, 0, contentBytes);
                this.socket.readFully(this.ch, contentBytes, chunkSize - contentBytes);
                this.pos = 0;
                this.length = 0;
                this.chPos = 0;
            } else {
                if (this.ch != this.buf) {
                    System.arraycopy(this.buf, this.pos, this.ch, 0, chunkSize);
                    this.chPos = 0;
                } else {
                    this.chPos = this.pos;
                }
                this.pos += chunkSize;
            }
            this.chLen = chunkSize;
            return true;
        }

        private int chunkSizeFor(int cap) {
            int n = -1 >>> Integer.numberOfLeadingZeros(cap - 1);
            return n + 1;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public String next() {
            try {
                return this.readChunkedLine();
            }
            catch (IOException | HttpException e) {
                log.debug("Event stream is closed by server");
                this.close();
                return null;
            }
        }

        private String readChunkedLine() throws IOException, HttpException {
            int end = this.findLineEnd(this.ch, this.chPos, this.chLen);
            if (end >= 0) {
                int lineLen = end - this.chPos;
                String line = Utf8.read(this.ch, this.chPos, lineLen);
                this.chLen -= ++lineLen;
                this.chPos += lineLen;
                return line;
            }
            ArrayList<byte[]> chunks = new ArrayList<byte[]>();
            int lineLen = 0;
            do {
                chunks.add(Arrays.copyOfRange(this.ch, this.chPos, this.chPos + this.chLen));
                lineLen += this.chLen;
                this.ch = this.buf;
                this.chPos = 0;
                this.chLen = 0;
                if (this.nextChunk()) continue;
                end = 0;
                break;
            } while ((end = this.findLineEnd(this.ch, this.chPos, this.chLen)) < 0);
            if ((lineLen += Math.max(end - this.chPos, 0)) == 0) {
                return "";
            }
            byte[] lineBytes = new byte[lineLen];
            int linePos = 0;
            for (byte[] b : chunks) {
                System.arraycopy(b, 0, lineBytes, linePos, b.length);
                linePos += b.length;
            }
            if (end > 0) {
                System.arraycopy(this.ch, this.chPos, lineBytes, linePos, end - this.chPos);
                linePos += end - this.chPos;
                this.chLen -= end - this.chPos + 1;
                this.chPos = end + 1;
            }
            assert (linePos == lineLen);
            String line = Utf8.read(lineBytes, 0, lineBytes.length);
            return line;
        }

        private int findLineEnd(byte[] b, int start, int len) {
            int end = start + len;
            while (start < end && b[start] != 10) {
                ++start;
            }
            return start >= end ? -1 : start;
        }

        @Override
        public void close() {
            if (this.socket == null) {
                return;
            }
            HttpClient.this.invalidateObject(this.socket);
            this.hasNext = false;
            this.socket = null;
        }
    }

    static class ResponseReader {
        Socket socket;
        byte[] buf;
        int length;
        int pos;

        ResponseReader(Socket socket, int bufferSize) throws IOException {
            this.socket = socket;
            this.buf = new byte[bufferSize];
            this.length = socket.read(this.buf, 0, bufferSize, 0);
        }

        Response readResponse(int method) throws IOException, HttpException {
            Response response = new Response(this.readResultCode());
            this.readResponseHeaders(response);
            this.readResponseBody(method, response);
            return response;
        }

        String readResultCode() throws IOException, HttpException {
            String responseHeader = this.readLine();
            if (responseHeader.length() <= 9) {
                throw new HttpException("Invalid response header: " + responseHeader);
            }
            return responseHeader.substring(9);
        }

        void readResponseHeaders(Response response) throws IOException, HttpException {
            String header;
            while (!(header = this.readLine()).isEmpty()) {
                response.addHeader(header);
            }
        }

        void readResponseBody(int method, Response response) throws IOException, HttpException {
            if (method != 3 && ResponseReader.mayHaveBody(response.getStatus())) {
                if ("chunked".equalsIgnoreCase(response.getHeader("Transfer-Encoding:"))) {
                    response.setBody(this.readChunkedBody());
                } else {
                    String contentLength = response.getHeader("Content-Length:");
                    if (contentLength != null) {
                        response.setBody(this.readBody(Integer.parseInt(contentLength)));
                    } else if ("close".equalsIgnoreCase(response.getHeader("Connection:"))) {
                        response.setBody(this.readBodyUntilClose());
                    } else {
                        log.debug("Content-Length unspecified: {}", (Object)response);
                        throw new HttpException("Content-Length unspecified");
                    }
                }
            }
        }

        String readLine() throws IOException, HttpException {
            int pos;
            byte[] buf = this.buf;
            int lineStart = pos = this.pos;
            do {
                if (pos != this.length) continue;
                if (pos >= buf.length) {
                    throw new HttpException("Line too long");
                }
                this.length += this.socket.read(buf, pos, buf.length - pos, 0);
            } while (buf[pos++] != 10);
            this.pos = pos;
            return Utf8.read(buf, lineStart, pos - lineStart - 2);
        }

        byte[] readChunkedBody() throws IOException, HttpException {
            ArrayList<byte[]> chunks = new ArrayList<byte[]>(4);
            while (true) {
                int chunkSize;
                if ((chunkSize = Integer.parseInt(this.readLine(), 16)) == 0) break;
                byte[] chunk = new byte[chunkSize];
                chunks.add(chunk);
                int contentBytes = this.length - this.pos;
                if (contentBytes < chunkSize) {
                    System.arraycopy(this.buf, this.pos, chunk, 0, contentBytes);
                    this.socket.readFully(chunk, contentBytes, chunkSize - contentBytes);
                    this.pos = 0;
                    this.length = 0;
                } else {
                    System.arraycopy(this.buf, this.pos, chunk, 0, chunkSize);
                    this.pos += chunkSize;
                    if (this.pos + 128 >= this.buf.length) {
                        System.arraycopy(this.buf, this.pos, this.buf, 0, this.length -= this.pos);
                        this.pos = 0;
                    }
                }
                this.readLine();
            }
            this.readLine();
            return this.mergeChunks(chunks);
        }

        byte[] readBody(int contentLength) throws IOException {
            byte[] body = new byte[contentLength];
            int contentBytes = this.length - this.pos;
            System.arraycopy(this.buf, this.pos, body, 0, contentBytes);
            if (contentBytes < body.length) {
                this.socket.readFully(body, contentBytes, body.length - contentBytes);
            }
            return body;
        }

        byte[] readBodyUntilClose() throws IOException {
            ArrayList<byte[]> chunks = new ArrayList<byte[]>(4);
            if (this.pos < this.length) {
                chunks.add(Arrays.copyOfRange(this.buf, this.pos, this.length));
            }
            try {
                int bytes;
                while ((bytes = this.socket.read(this.buf, 0, this.buf.length)) >= 0) {
                    chunks.add(Arrays.copyOf(this.buf, bytes));
                }
            }
            catch (SocketClosedException socketClosedException) {
                // empty catch block
            }
            return this.mergeChunks(chunks);
        }

        byte[] mergeChunks(List<byte[]> chunks) {
            if (chunks.size() == 1) {
                return chunks.get(0);
            }
            int totalBytes = 0;
            for (byte[] chunk : chunks) {
                totalBytes += chunk.length;
            }
            byte[] result = new byte[totalBytes];
            int position = 0;
            for (byte[] chunk : chunks) {
                System.arraycopy(chunk, 0, result, position, chunk.length);
                position += chunk.length;
            }
            return result;
        }

        private static boolean mayHaveBody(int status) {
            return status >= 200 && status != 204 && status != 304;
        }
    }
}

