/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.util.Cache;

public interface SslSessionCache {
    public static final Logger log = LoggerFactory.getLogger(SslSessionCache.class);

    public void resize(int var1);

    public void addSession(byte[] var1, byte[] var2);

    public byte[] getSession(byte[] var1);

    public void removeSession(byte[] var1);

    public static class Default
    implements SslSessionCache {
        private final Cache<Cache.EqualByteArray, byte[]> cache;
        static int CAPACITY = 1024;

        private static Cache.EqualByteArray toKey(byte[] bytes) {
            return new Cache.EqualByteArray(bytes);
        }

        public Default(int maxSize) {
            this.cache = Cache.newSoftMemoryCache(maxSize);
        }

        public Default() {
            this(CAPACITY);
        }

        @Override
        public void resize(int maxSize) {
            this.cache.setCapacity(maxSize);
        }

        @Override
        public void addSession(byte[] sessionId, byte[] session) {
            this.cache.put(Default.toKey(sessionId), session);
        }

        @Override
        public byte[] getSession(byte[] sessionId) {
            return this.cache.get(Default.toKey(sessionId));
        }

        @Override
        public void removeSession(byte[] sessionId) {
            this.cache.remove(Default.toKey(sessionId));
        }
    }

    public static class Singleton {
        private static volatile SslSessionCache INSTANCE;
        private static Factory FACTORY;
        private static int CAPACITY;

        public static synchronized void setFactory(Factory factory) {
            if (INSTANCE != null) {
                throw new IllegalStateException("Unable to change factory after lazy instantiation is done");
            }
            FACTORY = Objects.requireNonNull(factory);
        }

        public static synchronized void setCapacity(int capacity) {
            if (capacity < 0) {
                throw new IllegalArgumentException("Capacity must be positive");
            }
            if (INSTANCE != null && CAPACITY != capacity) {
                INSTANCE.resize(capacity);
            }
            CAPACITY = capacity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static SslSessionCache getInstance() {
            if (INSTANCE != null) return INSTANCE;
            Class<Singleton> clazz = Singleton.class;
            synchronized (Singleton.class) {
                if (INSTANCE != null) return INSTANCE;
                INSTANCE = FACTORY.create(CAPACITY);
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        private static synchronized void clearInstance() {
            INSTANCE = null;
        }

        static {
            FACTORY = Default::new;
            CAPACITY = Default.CAPACITY;
        }

        public static interface Factory {
            public SslSessionCache create(int var1);
        }
    }
}

