/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import one.nio.serial.DeserializeStream;

public class DeserializeInputStream
extends InputStream {
    private final InternalDeserializeStream stream;
    private final InputStream in;

    public DeserializeInputStream(InputStream in) {
        this.stream = new InternalDeserializeStream();
        this.in = in;
    }

    public DeserializeInputStream(InputStream in, int initBufferSize) {
        this.stream = new InternalDeserializeStream(initBufferSize);
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        this.stream.ensureOpen();
        return this.stream.readObject();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        try {
            this.stream.close();
        }
        finally {
            this.in.close();
        }
    }

    private class InternalDeserializeStream
    extends DeserializeStream {
        public InternalDeserializeStream() {
            super(new byte[400]);
            this.limit = this.offset;
        }

        public InternalDeserializeStream(int capacity) {
            super(new byte[capacity]);
            this.limit = this.offset;
        }

        @Override
        public ByteBuffer byteBuffer(int len) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(len);
            this.read(byteBuffer);
            return byteBuffer;
        }

        @Override
        protected long alloc(int size) throws IOException {
            long currentOffset;
            if (size > this.array.length) {
                int newSize = Math.max(size, this.array.length * 2);
                byte[] newArray = new byte[newSize];
                if (this.offset < this.limit) {
                    int position = (int)(this.offset - this.address);
                    int len = (int)(this.limit - this.offset);
                    System.arraycopy(this.array, position, newArray, 0, len);
                    this.limit -= (long)position;
                } else {
                    this.limit = this.address;
                }
                this.array = newArray;
                this.offset = this.address;
            }
            if (this.offset + (long)size > this.limit) {
                this.fillArray(size);
            }
            if ((this.offset = (currentOffset = this.offset) + (long)size) > this.limit) {
                throw new IndexOutOfBoundsException();
            }
            return currentOffset;
        }

        private void fillArray(int minSize) throws IOException {
            if (this.offset - this.address + (long)minSize > (long)this.array.length) {
                this.shiftArray();
            }
            int size = (int)(this.limit - this.offset);
            while (size < minSize) {
                int position = (int)(this.limit - this.address);
                int bytes = DeserializeInputStream.this.in.read(this.array, position, this.array.length - position);
                if (bytes > 0) {
                    size += bytes;
                    this.limit += (long)bytes;
                    continue;
                }
                if (bytes != -1) continue;
                throw new EOFException("Unexpected end of input stream");
            }
        }

        private void shiftArray() {
            int position = (int)(this.offset - this.address);
            int len = (int)(this.limit - this.offset);
            if (len > 0) {
                System.arraycopy(this.array, position, this.array, 0, len);
            }
            this.offset = this.address;
            this.limit -= (long)position;
        }

        private void ensureOpen() throws IOException {
            if (this.array == null) {
                throw new IOException("Stream closed");
            }
        }

        @Override
        public void close() {
            super.close();
            this.array = null;
        }
    }
}

