/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.CollectionSerializer;
import one.nio.serial.DataStream;
import one.nio.serial.FieldDescriptor;
import one.nio.serial.JsonReader;
import one.nio.serial.MapSerializer;
import one.nio.serial.Origin;
import one.nio.serial.Renamed;
import one.nio.serial.Repository;
import one.nio.serial.Serializer;
import one.nio.serial.gen.Delegate;
import one.nio.serial.gen.DelegateGenerator;
import one.nio.serial.gen.StubGenerator;
import one.nio.util.NativeReflection;

public class GeneratedSerializer
extends Serializer {
    static final AtomicInteger missedLocalFields = new AtomicInteger();
    static final AtomicInteger missedStreamFields = new AtomicInteger();
    static final AtomicInteger migratedFields = new AtomicInteger();
    static final AtomicInteger renamedFields = new AtomicInteger();
    static final AtomicInteger unsupportedFields = new AtomicInteger();
    private FieldDescriptor[] fds;
    private FieldDescriptor[] defaultFields;
    private Delegate delegate;

    GeneratedSerializer(Class cls) {
        super(cls);
        Field[] ownFields = this.getSerializableFields();
        this.fds = new FieldDescriptor[ownFields.length / 2];
        for (int i = 0; i < ownFields.length; i += 2) {
            this.fds[i / 2] = new FieldDescriptor(ownFields[i], ownFields[i + 1], i / 2);
        }
        this.defaultFields = new FieldDescriptor[0];
        this.checkFieldTypes();
        this.delegate = DelegateGenerator.instantiate(cls, this.fds, this.code());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeShort(this.fds.length);
        for (FieldDescriptor fd : this.fds) {
            fd.write(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fds = new FieldDescriptor[in.readUnsignedShort()];
        for (int i = 0; i < this.fds.length; ++i) {
            this.fds[i] = FieldDescriptor.read(in);
        }
        try {
            super.readExternal(in);
        }
        catch (ClassNotFoundException e) {
            if ((Repository.getOptions() & 0x10) == 0) {
                throw e;
            }
            this.cls = this.isException() ? StubGenerator.generateRegular(this.uniqueName("Ex"), "java/lang/Exception", this.fds) : StubGenerator.generateRegular(this.uniqueName("Stub"), "java/lang/Object", this.fds);
            this.origin = Origin.GENERATED;
        }
        Field[] ownFields = this.getSerializableFields();
        this.assignFields(ownFields, true);
        this.assignFields(ownFields, false);
        this.defaultFields = this.assignDefaultFields(ownFields);
        this.checkFieldTypes();
        this.delegate = DelegateGenerator.instantiate(this.cls, this.fds, this.code());
    }

    @Override
    public void skipExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int fds = in.readUnsignedShort();
        for (int i = 0; i < fds; ++i) {
            in.skipBytes(in.readUnsignedShort());
            if (in.readByte() >= 0) continue;
            in.skipBytes(in.readUnsignedShort());
        }
    }

    @Override
    public byte[] code() {
        return DelegateGenerator.generate(this.cls, this.fds, this.defaultFields);
    }

    public void calcSize(Object obj, CalcSizeStream css) throws IOException {
        this.delegate.calcSize(obj, css);
    }

    public void write(Object obj, DataStream out) throws IOException {
        this.delegate.write(obj, out);
    }

    public Object read(DataStream in) throws IOException, ClassNotFoundException {
        return this.delegate.read(in);
    }

    @Override
    public void skip(DataStream in) throws IOException, ClassNotFoundException {
        this.delegate.skip(in);
    }

    public void toJson(Object obj, StringBuilder builder) throws IOException {
        this.delegate.toJson(obj, builder);
    }

    public Object fromJson(JsonReader in) throws IOException, ClassNotFoundException {
        return this.delegate.fromJson(in);
    }

    @Override
    public void toJson(StringBuilder sb) {
        sb.append("{\"cls\":\"").append(this.descriptor).append("\",\"uid\":").append(this.uid).append(",\"fields\":{");
        for (int i = 0; i < this.fds.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append('\"').append(this.fds[i].name()).append("\":\"").append(this.fds[i].type()).append('\"');
        }
        sb.append("}}");
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("Fields:\n");
        for (FieldDescriptor fd : this.fds) {
            builder.append(" - Name: ").append(fd.name()).append('\n');
            builder.append("   Type: ").append(fd.type()).append('\n');
            if (fd.parentField() == null) continue;
            builder.append("   Parent: ").append(fd.parentField().getName()).append('\n');
        }
        return builder.toString();
    }

    private boolean isException() {
        return this.fds.length >= 3 && this.fds[0].is("detailMessage", "java.lang.String") && this.fds[1].is("cause", "java.lang.Throwable") && this.fds[2].is("stackTrace", "[Ljava.lang.StackTraceElement;");
    }

    private void assignFields(Field[] ownFields, boolean exactType) {
        for (FieldDescriptor fd : this.fds) {
            int found;
            if (fd.ownField() != null || (found = this.findField(fd, ownFields, exactType)) < 0) continue;
            fd.assignField(ownFields[found], ownFields[found + 1], found / 2);
            ownFields[found] = null;
        }
    }

    private FieldDescriptor[] assignDefaultFields(Field[] ownFields) {
        ArrayList<FieldDescriptor> defaultFields = new ArrayList<FieldDescriptor>();
        for (int i = 0; i < ownFields.length; i += 2) {
            Field f = ownFields[i];
            if (f == null) continue;
            this.logFieldMismatch("Local field is missed in stream", f.getType(), f.getDeclaringClass(), f.getName());
            missedLocalFields.incrementAndGet();
            defaultFields.add(new FieldDescriptor(f, null, i / 2));
        }
        return defaultFields.toArray(new FieldDescriptor[0]);
    }

    private int findField(FieldDescriptor fd, Field[] ownFields, boolean exactType) {
        String name = fd.name();
        Class type = fd.type().resolve();
        String oldName = null;
        int p = name.indexOf(124);
        if (p >= 0) {
            oldName = name.substring(p + 1);
            name = name.substring(0, p);
        }
        if (exactType) {
            Field f;
            int i;
            for (i = 0; i < ownFields.length; i += 2) {
                f = ownFields[i];
                if (f == null || f.getType() != type || !f.getName().equals(name)) continue;
                return i;
            }
            for (i = 0; i < ownFields.length; i += 2) {
                Renamed renamed;
                f = ownFields[i];
                if (f == null || f.getType() != type || (renamed = f.getAnnotation(Renamed.class)) == null || !renamed.from().equals(name)) continue;
                this.logFieldMismatch("Local field renamed from " + renamed.from(), f.getType(), f.getDeclaringClass(), f.getName());
                renamedFields.incrementAndGet();
                return i;
            }
            if (oldName != null) {
                for (i = 0; i < ownFields.length; i += 2) {
                    f = ownFields[i];
                    if (f == null || f.getType() != type || !f.getName().equals(oldName)) continue;
                    this.logFieldMismatch("Remote field renamed from " + oldName, f.getType(), f.getDeclaringClass(), f.getName());
                    renamedFields.incrementAndGet();
                    return i;
                }
            }
        } else {
            for (int i = 0; i < ownFields.length; i += 2) {
                Field f = ownFields[i];
                if (f == null || !f.getName().equals(name) && !f.getName().equals(oldName)) continue;
                this.logFieldMismatch("Field type migrated from " + type.getName(), f.getType(), f.getDeclaringClass(), f.getName());
                migratedFields.incrementAndGet();
                return i;
            }
            this.logFieldMismatch("Stream field is missed locally", type, this.cls, name);
            missedStreamFields.incrementAndGet();
        }
        return -1;
    }

    private Field[] getSerializableFields() {
        ArrayList<Field> list = new ArrayList<Field>();
        this.getSerializableFields(this.cls, null, list);
        return list.toArray(new Field[0]);
    }

    private void getSerializableFields(Class cls, Field parentField, ArrayList<Field> list) {
        if (cls != null) {
            this.getSerializableFields(cls.getSuperclass(), parentField, list);
            for (Field f : this.getDeclaredFields(cls)) {
                int modifiers = f.getModifiers();
                if ((modifiers & 8) != 0) continue;
                if ((modifiers & 0x80) == 0) {
                    if (f.isSynthetic() && !Repository.hasOptions(cls, 16)) {
                        this.logFieldMismatch("Skipping synthetic field", f.getType(), cls, f.getName());
                        continue;
                    }
                    list.add(f);
                    list.add(parentField);
                    continue;
                }
                if (!Repository.hasOptions(f.getType(), 4) || parentField != null) continue;
                this.logFieldMismatch("Inlining field", f.getType(), cls, f.getName());
                this.getSerializableFields(f.getType(), f, list);
            }
        }
    }

    private Field[] getDeclaredFields(Class cls) {
        try {
            return cls.getDeclaredFields();
        }
        catch (NoClassDefFoundError e) {
            Field[] filteredFields;
            Repository.log.warn("[" + Long.toHexString(this.uid) + "] Fields of the class " + cls.getName() + " refer to nonexistent class: " + e.getMessage());
            if (NativeReflection.IS_SUPPORTED && (filteredFields = NativeReflection.getFields(cls, false)) != null) {
                return filteredFields;
            }
            throw e;
        }
    }

    private void checkFieldTypes() {
        for (FieldDescriptor fd : this.fds) {
            Class<?> type;
            Field f = fd.ownField();
            if (f == null || Externalizable.class.isAssignableFrom(type = f.getType()) || Repository.hasOptions(type, 8) || (!Collection.class.isAssignableFrom(type) || CollectionSerializer.isValidType(type)) && (!Map.class.isAssignableFrom(type) || MapSerializer.isValidType(type))) continue;
            this.generateUid();
            this.logFieldMismatch("Unsupported field type", type, this.cls, f.getName());
            unsupportedFields.incrementAndGet();
        }
    }

    private void logFieldMismatch(String msg, Class type, Class holder, String name) {
        Repository.log.warn("[" + Long.toHexString(this.uid) + "] " + msg + ": " + type.getName() + ' ' + holder.getName() + '.' + name);
    }
}

