/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.io.OutputStream;
import one.nio.serial.PersistStream;

public class PersistOutputStream
extends OutputStream {
    private final InternalPersistStream stream;
    private final OutputStream out;

    public PersistOutputStream(OutputStream out) {
        this.stream = new InternalPersistStream();
        this.out = out;
    }

    public PersistOutputStream(OutputStream out, int initBufferSize) {
        this.stream = new InternalPersistStream(initBufferSize);
        this.out = out;
    }

    @Override
    public void write(int val) throws IOException {
        this.out.write(val);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.out.write(buf, off, len);
    }

    public void writeObject(Object obj) throws IOException {
        this.stream.ensureOpen();
        this.stream.writeObject(obj);
        this.stream.flushArray();
    }

    @Override
    public void flush() throws IOException {
        this.stream.flushArray();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        try (OutputStream out = this.out;
             InternalPersistStream stream = this.stream;){
            stream.flushArray();
        }
    }

    private class InternalPersistStream
    extends PersistStream {
        public InternalPersistStream() {
        }

        public InternalPersistStream(int capacity) {
            super(capacity);
        }

        @Override
        protected long alloc(int size) throws IOException {
            if (this.offset + (long)size > this.limit) {
                if (this.flushArray()) {
                    return this.alloc(size);
                }
                return super.alloc(size);
            }
            long currentOffset = this.offset;
            this.offset = currentOffset + (long)size;
            return currentOffset;
        }

        private boolean flushArray() throws IOException {
            if (this.array == null || this.offset == this.address) {
                return false;
            }
            int position = (int)(this.offset - this.address);
            PersistOutputStream.this.out.write(this.array, 0, position);
            this.offset = this.address;
            return true;
        }

        private void ensureOpen() throws IOException {
            if (this.array == null) {
                throw new IOException("Stream closed");
            }
        }

        @Override
        public void close() {
            super.close();
            this.array = null;
        }
    }
}

