/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial.gen;

import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class MagicAccessor {
    public static byte[] magicAccessorBridge() {
        String superClass = MagicAccessor.useSerializationConstructorAccessor() ? "jdk/internal/reflect/SerializationConstructorAccessorImpl" : "jdk/internal/reflect/MagicAccessorImpl";
        return MagicAccessor.generateClass("jdk/internal/reflect/MagicAccessorBridge", superClass);
    }

    public static byte[] sunMagicAccessor() {
        return MagicAccessor.generateClass("sun/reflect/MagicAccessorImpl", "jdk/internal/reflect/MagicAccessorBridge");
    }

    private static boolean useSerializationConstructorAccessor() {
        int majorVersion;
        String javaVersion = System.getProperty("java.version");
        int indexOfDot = javaVersion.indexOf(".");
        if (indexOfDot > 0) {
            javaVersion = javaVersion.substring(0, indexOfDot);
        }
        return (majorVersion = Integer.parseInt(javaVersion)) >= 22;
    }

    private static byte[] generateClass(String name, String superClass) {
        ClassWriter cv = new ClassWriter(3);
        cv.visit(50, 1, name, null, superClass, new String[0]);
        MethodVisitor mv = cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superClass, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitEnd();
        cv.visitEnd();
        return cv.toByteArray();
    }
}

