/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server;

import java.io.IOException;
import java.util.Iterator;
import one.nio.net.Selector;
import one.nio.net.Session;
import one.nio.os.Proc;
import one.nio.os.SchedulingPolicy;
import one.nio.server.PayloadThread;

public final class SelectorThread
extends PayloadThread {
    private static final int BUFFER_SIZE = 64000;
    public final Selector selector = Selector.create();
    public final int dedicatedCpu;
    long operations;
    long sessions;
    int maxReady;

    public SelectorThread(int num, int dedicatedCpu, SchedulingPolicy schedulingPolicy, String name) throws IOException {
        super(name);
        this.dedicatedCpu = dedicatedCpu;
        this.setSchedulingPolicy(schedulingPolicy);
    }

    public void shutdown() {
        this.selector.close();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        if (this.schedulingPolicy != null) {
            this.schedulingPolicy.apply();
        }
        if (this.dedicatedCpu >= 0 && Proc.IS_SUPPORTED) {
            Proc.setDedicatedCpu(0, this.dedicatedCpu);
        }
        byte[] buffer = new byte[64000];
        while (this.selector.isOpen()) {
            int ready = 0;
            Iterator<Session> selectedSessions = this.selector.select();
            while (selectedSessions.hasNext()) {
                Session session = selectedSessions.next();
                try {
                    session.process(buffer);
                }
                catch (Throwable e) {
                    session.handleException(e);
                }
                ++ready;
            }
            ++this.operations;
            this.sessions += (long)ready;
            if (ready <= this.maxReady) continue;
            this.maxReady = ready;
        }
    }
}

