/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server.acceptor;

import java.io.IOException;
import one.nio.net.Session;
import one.nio.net.Socket;
import one.nio.server.AcceptorConfig;
import one.nio.server.RejectedSessionException;
import one.nio.server.Server;
import one.nio.server.acceptor.AcceptorSupport;
import one.nio.server.acceptor.DefaultAcceptorGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AcceptorThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(AcceptorThread.class);
    final DefaultAcceptorGroup group;
    final int num;
    final String address;
    final int port;
    final int backlog;
    final Server server;
    final Socket serverSocket;
    volatile long acceptedSessions;
    volatile long rejectedSessions;

    AcceptorThread(Server server, AcceptorConfig config, DefaultAcceptorGroup group, int num) throws IOException {
        super("NIO Acceptor " + config.address + ":" + config.port + " #" + num);
        this.group = group;
        this.num = num;
        this.address = config.address;
        this.port = config.port;
        this.backlog = config.backlog;
        this.server = server;
        Socket serverSocket = AcceptorSupport.createServerSocket(config);
        serverSocket.bind(this.address, this.port, this.backlog);
        this.serverSocket = serverSocket;
    }

    void reconfigure(AcceptorConfig config) throws IOException {
        AcceptorSupport.reconfigureSocket(this.serverSocket, config);
    }

    void shutdown() {
        this.serverSocket.close();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        try {
            this.serverSocket.listen(this.backlog);
        }
        catch (IOException e) {
            log.error("Cannot start listening at {}", (Object)this.port, (Object)e);
            return;
        }
        finally {
            this.group.syncLatch.countDown();
        }
        while (this.serverSocket.isOpen()) {
            Socket socket = null;
            try {
                socket = this.serverSocket.acceptNonBlocking();
                Session session = this.server.createSession(socket);
                this.server.register(session, this.num, this.group.size());
                ++this.acceptedSessions;
            }
            catch (RejectedSessionException e) {
                log.debug("Rejected session from {}", (Object)socket.getRemoteAddress(), (Object)e);
                ++this.rejectedSessions;
                socket.close();
            }
            catch (Throwable e) {
                if (this.serverSocket.isOpen()) {
                    log.error("Cannot accept incoming connection", e);
                }
                if (socket == null) continue;
                socket.close();
            }
        }
    }
}

