/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server.acceptor;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import one.nio.server.AcceptorConfig;
import one.nio.server.Server;
import one.nio.server.acceptor.AcceptorThread;

class DefaultAcceptorGroup {
    private final Server server;
    private final String address;
    private final int port;
    private volatile AcceptorThread[] acceptors;
    CountDownLatch syncLatch;

    public DefaultAcceptorGroup(Server server, AcceptorConfig ac) throws IOException {
        this.server = server;
        this.address = ac.address;
        this.port = ac.port;
        AcceptorThread[] acceptors = new AcceptorThread[ac.threads];
        for (int threadId = 0; threadId < ac.threads; ++threadId) {
            acceptors[threadId] = new AcceptorThread(server, ac, this, threadId);
        }
        this.acceptors = acceptors;
    }

    public void reconfigure(AcceptorConfig ac) throws IOException {
        if (!this.isSameAddressPort(ac)) {
            throw new IllegalArgumentException("Acceptor config has different address:port");
        }
        AcceptorThread[] oldAcceptors = this.acceptors;
        if (ac.threads < oldAcceptors.length) {
            for (int i = 0; i < oldAcceptors.length; ++i) {
                if (i < ac.threads) {
                    oldAcceptors[i].reconfigure(ac);
                    continue;
                }
                oldAcceptors[i].shutdown();
            }
            this.acceptors = Arrays.copyOf(oldAcceptors, ac.threads);
        } else {
            AcceptorThread[] newAcceptors = Arrays.copyOf(oldAcceptors, ac.threads);
            for (int i = 0; i < newAcceptors.length; ++i) {
                if (newAcceptors[i] != null) {
                    newAcceptors[i].reconfigure(ac);
                    continue;
                }
                newAcceptors[i] = new AcceptorThread(this.server, ac, this, i);
                newAcceptors[i].start();
            }
            this.acceptors = newAcceptors;
        }
    }

    public boolean isSameAddressPort(AcceptorConfig ac) {
        return ac.address.equals(this.address) && ac.port == this.port;
    }

    public void start() {
        AcceptorThread[] acceptors = this.acceptors;
        this.syncLatch = new CountDownLatch(acceptors.length);
        for (AcceptorThread acceptor : acceptors) {
            acceptor.start();
        }
    }

    public void syncStart() throws InterruptedException {
        if (this.syncLatch != null) {
            this.syncLatch.await();
        }
    }

    public void shutdown() {
        for (AcceptorThread acceptor : this.acceptors) {
            acceptor.shutdown();
        }
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public int size() {
        AcceptorThread[] acceptors = this.acceptors;
        return acceptors == null ? 0 : acceptors.length;
    }

    public long getAcceptedSessions() {
        long sum = 0L;
        for (AcceptorThread acceptor : this.acceptors) {
            sum += acceptor.acceptedSessions;
        }
        return sum;
    }

    public long getRejectedSessions() {
        long sum = 0L;
        for (AcceptorThread acceptor : this.acceptors) {
            sum += acceptor.rejectedSessions;
        }
        return sum;
    }

    public void resetCounters() {
        for (AcceptorThread acceptor : this.acceptors) {
            acceptor.acceptedSessions = 0L;
            acceptor.rejectedSessions = 0L;
        }
    }

    public String toString() {
        return "DefaultAcceptorGroup{address='" + this.address + '\'' + ", port=" + this.port + ", size=" + this.size() + '}';
    }
}

