/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server.acceptor;

import java.io.IOException;
import java.util.Arrays;
import one.nio.server.AcceptorConfig;
import one.nio.server.Server;
import one.nio.server.acceptor.Acceptor;
import one.nio.server.acceptor.MultiAcceptorGroup;
import one.nio.server.acceptor.MultiAcceptorThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MultiAcceptor
implements Acceptor {
    private static final Logger log = LoggerFactory.getLogger(MultiAcceptor.class);
    private final MultiAcceptorThread thread;
    private volatile MultiAcceptorGroup[] acceptorGroups;

    MultiAcceptor(Server server, AcceptorConfig ... configs) throws IOException {
        this.thread = new MultiAcceptorThread(server);
        MultiAcceptorGroup[] newGroups = new MultiAcceptorGroup[configs.length];
        for (int configIdx = 0; configIdx < configs.length; ++configIdx) {
            AcceptorConfig config = configs[configIdx];
            this.validateConfig(config);
            newGroups[configIdx] = new MultiAcceptorGroup(this.thread, config);
        }
        this.setAcceptorGroups(newGroups);
    }

    @Override
    public void reconfigure(AcceptorConfig ... configs) throws IOException {
        MultiAcceptorGroup[] oldGroups = (MultiAcceptorGroup[])this.acceptorGroups.clone();
        MultiAcceptorGroup[] newGroups = new MultiAcceptorGroup[configs.length];
        for (int configIdx = 0; configIdx < configs.length; ++configIdx) {
            MultiAcceptorGroup oldGroup;
            AcceptorConfig newConfig = configs[configIdx];
            this.validateConfig(newConfig);
            MultiAcceptorGroup multiAcceptorGroup = oldGroup = configIdx < oldGroups.length ? oldGroups[configIdx] : null;
            if (oldGroup != null && oldGroup.isSameAddressPort(newConfig)) {
                log.info("Reconfiguring acceptor group: {}", (Object)oldGroup);
                oldGroup.reconfigure(newConfig);
                newGroups[configIdx] = oldGroup;
                oldGroups[configIdx] = null;
                continue;
            }
            MultiAcceptorGroup newGroup = new MultiAcceptorGroup(this.thread, newConfig);
            log.info("New acceptor group: {}", (Object)newGroup);
            newGroups[configIdx] = newGroup;
            newGroup.start();
        }
        for (MultiAcceptorGroup oldGroup : oldGroups) {
            if (oldGroup == null) continue;
            oldGroup.close();
        }
        this.setAcceptorGroups(newGroups);
    }

    @Override
    public void start() {
        this.thread.start();
        for (MultiAcceptorGroup group : this.acceptorGroups) {
            try {
                group.start();
            }
            catch (IOException e) {
                log.error("Cannot start listening at {}", (Object)group, (Object)e);
            }
        }
    }

    @Override
    public void syncStart() {
    }

    @Override
    public void shutdown() {
        this.thread.shutdown();
    }

    @Override
    public long getAcceptedSessions() {
        return this.thread.acceptedSessions;
    }

    @Override
    public long getRejectedSessions() {
        return this.thread.rejectedSessions;
    }

    @Override
    public void resetCounters() {
        this.thread.acceptedSessions = 0L;
        this.thread.rejectedSessions = 0L;
    }

    @Override
    public int getSinglePort() {
        return this.acceptorGroups[0].getPort();
    }

    private void validateConfig(AcceptorConfig newConfig) {
        if (newConfig.threads <= 0) {
            throw new IllegalArgumentException("Cannot create acceptor with 0 ports");
        }
        if (newConfig.threads > 1 && !newConfig.reusePort) {
            throw new IllegalArgumentException("Cannot create multiport acceptor without reusePort");
        }
    }

    private void setAcceptorGroups(MultiAcceptorGroup[] newGroups) {
        this.acceptorGroups = newGroups;
        this.thread.setName("NIO MultiAcceptor " + Arrays.toString(newGroups));
    }
}

