/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server.acceptor;

import java.io.IOException;
import java.util.Arrays;
import one.nio.net.Socket;
import one.nio.server.AcceptorConfig;
import one.nio.server.acceptor.AcceptorSupport;
import one.nio.server.acceptor.MultiAcceptSession;
import one.nio.server.acceptor.MultiAcceptorThread;

public class MultiAcceptorGroup {
    private final MultiAcceptorThread thread;
    private final String address;
    private final int port;
    private volatile MultiAcceptSession[] sessions;

    MultiAcceptorGroup(MultiAcceptorThread thread, AcceptorConfig config) throws IOException {
        this.thread = thread;
        this.address = config.address;
        this.port = config.port;
        MultiAcceptSession[] sessions = new MultiAcceptSession[config.threads];
        for (int sessionIdx = 0; sessionIdx < config.threads; ++sessionIdx) {
            sessions[sessionIdx] = this.createMultiAcceptSession(config, sessionIdx);
        }
        this.sessions = sessions;
    }

    boolean isSameAddressPort(AcceptorConfig config) {
        return this.address.equals(config.address) && this.port == config.port;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    void start() throws IOException {
        for (MultiAcceptSession session : this.sessions) {
            this.thread.register(session);
        }
    }

    void close() {
        for (MultiAcceptSession session : this.sessions) {
            session.close();
        }
    }

    int size() {
        MultiAcceptSession[] sessions = this.sessions;
        return sessions == null ? 0 : sessions.length;
    }

    void reconfigure(AcceptorConfig newConfig) throws IOException {
        if (!this.isSameAddressPort(newConfig)) {
            throw new IllegalArgumentException("Acceptor config has different address:port");
        }
        MultiAcceptSession[] oldSessions = this.sessions;
        MultiAcceptSession[] newSessions = Arrays.copyOf(oldSessions, newConfig.threads);
        if (oldSessions.length > newConfig.threads) {
            for (int sessionIdx = 0; sessionIdx < oldSessions.length; ++sessionIdx) {
                if (sessionIdx < newSessions.length) {
                    oldSessions[sessionIdx].reconfigure(newConfig);
                    continue;
                }
                oldSessions[sessionIdx].close();
            }
        } else {
            for (int sessionIdx = 0; sessionIdx < newSessions.length; ++sessionIdx) {
                MultiAcceptSession session = newSessions[sessionIdx];
                if (session != null) {
                    session.reconfigure(newConfig);
                    continue;
                }
                MultiAcceptSession acceptSession = this.createMultiAcceptSession(newConfig, sessionIdx);
                this.thread.register(acceptSession);
            }
        }
        this.sessions = newSessions;
    }

    public String toString() {
        return this.address + ':' + this.port + 'x' + this.size();
    }

    private MultiAcceptSession createMultiAcceptSession(AcceptorConfig config, int sessionIdx) throws IOException {
        Socket serverSocket = AcceptorSupport.createServerSocket(config);
        serverSocket.setBlocking(false);
        serverSocket.bind(config.address, config.port, config.backlog);
        return new MultiAcceptSession(serverSocket, config.backlog, this, sessionIdx);
    }
}

