/*
 * Decompiled with CFR 0.152.
 */
package one.nio.ws;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import one.nio.http.Request;
import one.nio.util.Base64;

public class WebSocketHeaders {
    public static final String CONNECTION = "Connection: ";
    public static final String UPGRADE = "Upgrade: ";
    public static final String KEY = "Sec-WebSocket-Key: ";
    public static final String VERSION = "Sec-WebSocket-Version: ";
    public static final String ACCEPT = "Sec-WebSocket-Accept: ";
    public static final String EXTENSIONS = "Sec-WebSocket-Extensions: ";
    public static final String PROTOCOL = "Sec-WebSocket-Protocol: ";
    private static final String ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final ThreadLocal<MessageDigest> SHA1 = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("SHA-1 not supported on this platform");
        }
    });

    public static boolean isUpgradableRequest(Request request) {
        String upgradeHeader = request.getHeader(UPGRADE);
        String connectionHeader = request.getHeader(CONNECTION);
        return upgradeHeader != null && upgradeHeader.toLowerCase().contains("websocket") && connectionHeader != null && connectionHeader.toLowerCase().contains("upgrade");
    }

    public static String createVersionHeader(String version) {
        return VERSION + version;
    }

    public static String createAcceptHeader(Request request) {
        return ACCEPT + WebSocketHeaders.generateHash(request);
    }

    private static String generateHash(Request request) {
        String key = request.getHeader(KEY);
        String acceptSeed = key + ACCEPT_GUID;
        byte[] sha1 = WebSocketHeaders.sha1(acceptSeed.getBytes(StandardCharsets.ISO_8859_1));
        return new String(Base64.encode(sha1));
    }

    private static byte[] sha1(byte[] data) {
        MessageDigest digest = SHA1.get();
        digest.reset();
        return digest.digest(data);
    }
}

