/*
 * Decompiled with CFR 0.152.
 */
package one.nio.ws;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import one.nio.http.HttpSession;
import one.nio.http.Request;
import one.nio.http.Response;
import one.nio.net.Socket;
import one.nio.ws.WebSocketHeaders;
import one.nio.ws.WebSocketServer;
import one.nio.ws.WebSocketServerConfig;
import one.nio.ws.exception.HandshakeException;
import one.nio.ws.exception.VersionException;
import one.nio.ws.exception.WebSocketException;
import one.nio.ws.extension.Extension;
import one.nio.ws.extension.ExtensionRequest;
import one.nio.ws.extension.ExtensionRequestParser;
import one.nio.ws.extension.PerMessageDeflate;
import one.nio.ws.message.BinaryMessage;
import one.nio.ws.message.CloseMessage;
import one.nio.ws.message.Message;
import one.nio.ws.message.MessageReader;
import one.nio.ws.message.MessageWriter;
import one.nio.ws.message.PingMessage;
import one.nio.ws.message.PongMessage;
import one.nio.ws.message.TextMessage;

public class WebSocketSession
extends HttpSession {
    public static final String VERSION_13 = "13";
    private final WebSocketServer server;
    private final WebSocketServerConfig config;
    private final List<Extension> extensions;
    private MessageReader reader;
    private MessageWriter writer;

    public WebSocketSession(Socket socket, WebSocketServer server, WebSocketServerConfig config) {
        super(socket, server);
        this.server = server;
        this.config = config;
        this.extensions = new ArrayList<Extension>();
    }

    @Override
    public int checkStatus(long currentTime, long keepAlive) {
        if (currentTime - this.lastAccessTime < keepAlive) {
            return 0;
        }
        try {
            if (this.wasSelected) {
                this.sendMessage(PingMessage.EMPTY);
            }
            return 0;
        }
        catch (IOException e) {
            return 2;
        }
    }

    @Override
    protected void processRead(byte[] buffer) throws IOException {
        if (this.reader == null) {
            super.processRead(buffer);
        } else {
            Message<?> message = this.reader.read();
            if (message != null) {
                this.handleMessage(this, message);
            }
        }
    }

    public void handshake(Request request) throws IOException {
        try {
            this.validateRequest(request);
            Response response = this.createResponse(request);
            this.reader = new MessageReader(this, this.extensions);
            this.writer = new MessageWriter(this, this.extensions);
            this.sendResponse(response);
        }
        catch (VersionException e) {
            log.debug("Unsupported version", (Throwable)e);
            Response response = new Response("426 Upgrade Required", Response.EMPTY);
            response.addHeader(WebSocketHeaders.createVersionHeader(VERSION_13));
            this.sendResponse(response);
        }
        catch (HandshakeException e) {
            log.debug("Handshake error", (Throwable)e);
            this.sendError("400 Bad Request", e.getMessage());
        }
    }

    public void sendMessage(Message<?> message) throws IOException {
        if (this.writer == null) {
            throw new IllegalStateException("websocket message was sent before handshake");
        }
        this.writer.write(message);
    }

    protected void handleMessage(WebSocketSession session, Message<?> message) throws IOException {
        switch (message.opcode()) {
            case PING: {
                this.server.handleMessage(session, (PingMessage)message);
                break;
            }
            case PONG: {
                this.server.handleMessage(session, (PongMessage)message);
                break;
            }
            case TEXT: {
                this.server.handleMessage(session, (TextMessage)message);
                break;
            }
            case BINARY: {
                this.server.handleMessage(session, (BinaryMessage)message);
                break;
            }
            case CLOSE: {
                this.server.handleMessage(session, (CloseMessage)message);
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected message with opcode: " + (Object)((Object)message.opcode()));
            }
        }
    }

    @Override
    public void handleException(Throwable e) {
        if (e instanceof WebSocketException) {
            log.error("Cannot process session from {}", (Object)this.getRemoteHost(), (Object)e);
            this.close(((WebSocketException)e).code());
            return;
        }
        super.handleException(e);
    }

    public void close(short code) {
        try {
            this.sendMessage(new CloseMessage(code));
        }
        catch (Exception e) {
            log.warn("error while sending closing frame", (Throwable)e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        this.closeExtensions();
        super.close();
    }

    protected void validateRequest(Request request) {
        String version = request.getHeader("Sec-WebSocket-Version: ");
        if (!VERSION_13.equals(version)) {
            throw new VersionException(version);
        }
        if (request.getMethod() != 1) {
            throw new HandshakeException("only GET method supported");
        }
        if (request.getHeader("Sec-WebSocket-Key: ") == null) {
            throw new HandshakeException("missing websocket key");
        }
        if (!WebSocketHeaders.isUpgradableRequest(request)) {
            throw new HandshakeException("missing upgrade header");
        }
    }

    protected Response createResponse(Request request) {
        Response response = new Response("101 Switching Protocols", Response.EMPTY);
        response.addHeader("Upgrade: websocket");
        response.addHeader("Connection: Upgrade");
        response.addHeader(WebSocketHeaders.createAcceptHeader(request));
        this.processExtensions(request, response);
        this.processProtocol(request, response);
        return response;
    }

    protected void processProtocol(Request request, Response response) {
        String protocols = request.getHeader("Sec-WebSocket-Protocol: ");
        if (protocols != null) {
            for (String protocol : protocols.split(",")) {
                if (!this.config.isSupportedProtocol(protocol)) continue;
                response.addHeader("Sec-WebSocket-Protocol: " + protocol);
                break;
            }
        }
    }

    protected void processExtensions(Request request, Response response) {
        String extensionsHeader = request.getHeader("Sec-WebSocket-Extensions: ");
        if (extensionsHeader == null || extensionsHeader.isEmpty()) {
            return;
        }
        List<ExtensionRequest> extensionRequests = ExtensionRequestParser.parse(extensionsHeader);
        if (extensionRequests.isEmpty()) {
            return;
        }
        StringBuilder responseHeaderBuilder = new StringBuilder("Sec-WebSocket-Extensions: ");
        for (ExtensionRequest extensionRequest : extensionRequests) {
            Extension extension = this.createExtension(extensionRequest);
            if (extension == null) continue;
            this.extensions.add(extension);
            if (this.extensions.size() > 1) {
                responseHeaderBuilder.append(',');
            }
            extension.appendResponseHeaderValue(responseHeaderBuilder);
        }
        if (!this.extensions.isEmpty()) {
            response.addHeader(responseHeaderBuilder.toString());
        }
    }

    protected Extension createExtension(ExtensionRequest request) {
        if ("permessage-deflate".equals(request.getName())) {
            return PerMessageDeflate.negotiate(request.getParameters());
        }
        return null;
    }

    private void closeExtensions() {
        for (Extension extension : this.extensions) {
            try {
                extension.close();
            }
            catch (Exception e) {
                log.warn("error while closing extension", (Throwable)e);
            }
        }
    }
}

