/*
 * Decompiled with CFR 0.152.
 */
package one.nio.ws.extension;

import java.util.ArrayList;
import java.util.List;
import one.nio.ws.extension.ExtensionRequest;

public class ExtensionRequestParser {
    public static List<ExtensionRequest> parse(String header) {
        ArrayList<ExtensionRequest> result = new ArrayList<ExtensionRequest>();
        for (String unparsedExtension : header.split(",")) {
            String[] unparsedParameters = unparsedExtension.split(";");
            ExtensionRequest request = new ExtensionRequest(unparsedParameters[0].trim());
            for (int i = 1; i < unparsedParameters.length; ++i) {
                String value;
                String name;
                int equalsPos = unparsedParameters[i].indexOf(61);
                if (equalsPos == -1) {
                    name = unparsedParameters[i].trim();
                    value = null;
                } else {
                    name = unparsedParameters[i].substring(0, equalsPos).trim();
                    value = unparsedParameters[i].substring(equalsPos + 1).trim();
                    int len = value.length();
                    if (len > 1 && value.charAt(0) == '\"' && value.charAt(len - 1) == '\"') {
                        value = value.substring(1, value.length() - 1);
                    }
                }
                if (ExtensionRequestParser.containsDelims(name) || ExtensionRequestParser.containsDelims(value)) {
                    throw new IllegalArgumentException("An illegal extension parameter was specified with name [" + name + "] and value [" + value + "]");
                }
                request.addParameter(name, value);
            }
            result.add(request);
        }
        return result;
    }

    private static boolean containsDelims(String input) {
        if (input == null || input.isEmpty()) {
            return false;
        }
        for (int i = 0; i < input.length(); ++i) {
            switch (input.charAt(i)) {
                case '\"': 
                case ',': 
                case ';': 
                case '=': {
                    return true;
                }
            }
        }
        return false;
    }
}

