/*
 * Decompiled with CFR 0.152.
 */
package one.nio.ws.extension;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import one.nio.ws.exception.HandshakeException;
import one.nio.ws.extension.Extension;
import one.nio.ws.frame.Frame;

public class PerMessageDeflate
implements Extension {
    private static final String SERVER_NO_CONTEXT_TAKEOVER = "server_no_context_takeover";
    private static final String CLIENT_NO_CONTEXT_TAKEOVER = "client_no_context_takeover";
    private static final byte[] EOM_BYTES = new byte[]{0, 0, -1, -1};
    private static final int RSV_BITMASK = 4;
    private static final int INPUT_BUFFER_SIZE = Integer.getInteger("one.nio.ws.permessage-deflate.INPUT_BUFFER_SIZE", 2048);
    private static final int OUTPUT_BUFFER_SIZE = Integer.getInteger("one.nio.ws.permessage-deflate.OUTPUT_BUFFER_SIZE", 2048);
    public static final String NAME = "permessage-deflate";
    private final boolean clientContextTakeover;
    private final boolean serverContextTakeover;
    private final Inflater inflater = new Inflater(true);
    private final byte[] inputBuffer = new byte[INPUT_BUFFER_SIZE];
    private boolean skipDecompression = false;
    private final Deflater deflater = new Deflater(-1, true);
    private final byte[] outputBuffer = new byte[OUTPUT_BUFFER_SIZE];

    public static PerMessageDeflate negotiate(Map<String, String> parameters) {
        boolean clientContextTakeover = true;
        boolean serverContextTakeover = true;
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            String name = parameter.getKey();
            if (SERVER_NO_CONTEXT_TAKEOVER.equals(name)) {
                if (serverContextTakeover) {
                    serverContextTakeover = false;
                } else {
                    throw new HandshakeException("Duplicate definition of the server_no_context_takeover extension parameter");
                }
            }
            if (!CLIENT_NO_CONTEXT_TAKEOVER.equals(name)) continue;
            if (clientContextTakeover) {
                clientContextTakeover = false;
                continue;
            }
            throw new HandshakeException("Duplicate definition of the client_no_context_takeover extension parameter");
        }
        return new PerMessageDeflate(clientContextTakeover, serverContextTakeover);
    }

    private PerMessageDeflate(boolean clientContextTakeover, boolean serverContextTakeover) {
        this.clientContextTakeover = clientContextTakeover;
        this.serverContextTakeover = serverContextTakeover;
    }

    @Override
    public void appendResponseHeaderValue(StringBuilder builder) {
        builder.append(NAME);
        if (!this.clientContextTakeover) {
            builder.append("; ").append(CLIENT_NO_CONTEXT_TAKEOVER);
        }
        if (!this.serverContextTakeover) {
            builder.append("; ").append(SERVER_NO_CONTEXT_TAKEOVER);
        }
    }

    @Override
    public void transformInput(Frame frame) throws IOException {
        if (frame.isControl()) {
            return;
        }
        if (!frame.getOpcode().isContinuation()) {
            boolean bl = this.skipDecompression = (frame.getRsv() & 4) == 0;
        }
        if (this.skipDecompression) {
            return;
        }
        frame.setPayload(this.decompress(frame.isFin(), frame.getPayload()));
        frame.setRsv(frame.getRsv() & 0xFFFFFFFB);
    }

    @Override
    public void transformOutput(Frame frame) throws IOException {
        if (frame.isControl()) {
            return;
        }
        if (frame.getPayloadLength() == 0) {
            return;
        }
        frame.setPayload(this.compress(frame.getPayload()));
        frame.setRsv(frame.getRsv() + 4);
    }

    @Override
    public void close() {
        this.inflater.end();
        this.deflater.end();
    }

    private byte[] decompress(boolean fin, byte[] payload) throws IOException {
        boolean usedEomBytes = false;
        if (payload == null || payload.length == 0) {
            return payload;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            block19: {
                this.inflater.setInput(payload);
                while (true) {
                    int uncompressedBytes;
                    try {
                        uncompressedBytes = this.inflater.inflate(this.inputBuffer);
                    }
                    catch (DataFormatException e) {
                        throw new IOException("Failed to decompress WebSocket frame", e);
                    }
                    if (uncompressedBytes > 0) {
                        out.write(this.inputBuffer, 0, uncompressedBytes);
                        continue;
                    }
                    if (!this.inflater.needsInput() || usedEomBytes) break;
                    if (fin) {
                        this.inflater.setInput(EOM_BYTES);
                        usedEomBytes = true;
                        continue;
                    }
                    break block19;
                    break;
                }
                if (fin && !this.clientContextTakeover) {
                    this.inflater.reset();
                }
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    private byte[] compress(byte[] payload) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int compressedLength;
            this.deflater.setInput(payload, 0, payload.length);
            do {
                compressedLength = this.deflater.deflate(this.outputBuffer, 0, this.outputBuffer.length, 2);
                out.write(this.outputBuffer, 0, compressedLength);
            } while (compressedLength > 0);
            byte[] result = out.toByteArray();
            if (this.endsWithTail(result)) {
                result = Arrays.copyOf(result, result.length - EOM_BYTES.length);
            }
            if (!this.serverContextTakeover) {
                this.deflater.reset();
            }
            byte[] byArray = result;
            return byArray;
        }
    }

    private boolean endsWithTail(byte[] payload) {
        if (payload.length < 4) {
            return false;
        }
        int length = payload.length;
        for (int i = 0; i < EOM_BYTES.length; ++i) {
            if (EOM_BYTES[i] == payload[length - EOM_BYTES.length + i]) continue;
            return false;
        }
        return true;
    }
}

