/*
 * Decompiled with CFR 0.152.
 */
package one.nio.ws.frame;

import java.nio.ByteBuffer;
import one.nio.ws.frame.Opcode;

public class Frame {
    private final boolean fin;
    private final Opcode opcode;
    private int rsv;
    private int payloadLength;
    private byte[] mask;
    private byte[] payload;

    public Frame(boolean fin, Opcode opcode, int rsv, int payloadLength) {
        this.fin = fin;
        this.opcode = opcode;
        this.rsv = rsv;
        this.payloadLength = payloadLength;
    }

    public Frame(Opcode opcode, byte[] payload) {
        this.fin = true;
        this.rsv = 0;
        this.opcode = opcode;
        this.payload = payload;
        this.payloadLength = payload.length;
    }

    public boolean isFin() {
        return this.fin;
    }

    public int getRsv() {
        return this.rsv;
    }

    public void setRsv(int rsv) {
        this.rsv = rsv;
    }

    public Opcode getOpcode() {
        return this.opcode;
    }

    public boolean isControl() {
        return this.opcode.isControl();
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    public byte[] getMask() {
        return this.mask;
    }

    public void setMask(byte[] mask) {
        this.mask = mask;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
        this.payloadLength = payload.length;
    }

    public void unmask() {
        int pos;
        if (this.mask == null) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.payload);
        int intMask = ByteBuffer.wrap(this.mask).getInt();
        while (buffer.remaining() >= 4) {
            pos = buffer.position();
            buffer.putInt(pos, buffer.getInt() ^ intMask);
        }
        while (buffer.hasRemaining()) {
            pos = buffer.position();
            buffer.put(pos, (byte)(buffer.get() ^ this.mask[pos % 4]));
        }
        this.setPayload(buffer.array());
        this.mask = null;
    }
}

