/*
 * Decompiled with CFR 0.152.
 */
package one.nio.ws.frame;

import java.io.IOException;
import java.util.Arrays;
import one.nio.net.Session;
import one.nio.ws.exception.CannotAcceptException;
import one.nio.ws.exception.ProtocolException;
import one.nio.ws.exception.TooBigException;
import one.nio.ws.exception.WebSocketException;
import one.nio.ws.frame.Frame;
import one.nio.ws.frame.Opcode;

public class FrameReader {
    private static final int HEADER_LENGTH = 14;
    private static final int FIRST_HEADER_LENGTH = 2;
    private static final int MASK_LENGTH = 4;
    private final Session session;
    private final byte[] header;
    private final int maxFramePayloadLength = Integer.getInteger("one.nio.ws.MAX_FRAME_PAYLOAD_LENGTH", 131072);
    private Frame frame;
    private int ptr;

    public FrameReader(Session session) {
        this.session = session;
        this.header = new byte[14];
    }

    public Frame read() throws IOException {
        Frame frame = this.frame;
        int ptr = this.ptr;
        if (frame == null) {
            if ((ptr += this.session.read(this.header, ptr, 2 - ptr)) < 2) {
                this.ptr = ptr;
                return null;
            }
            frame = this.createFrame(this.header);
            ptr = 0;
            this.frame = frame;
        }
        if (frame.getPayload() == null) {
            int len;
            int payloadLength = frame.getPayloadLength();
            int n = payloadLength == 126 ? 2 : (len = payloadLength == 127 ? 8 : 0);
            if (len > 0) {
                if ((ptr += this.session.read(this.header, ptr, len - ptr)) < len) {
                    this.ptr = ptr;
                    return null;
                }
                payloadLength = this.byteArrayToInt(this.header, len);
            }
            if (payloadLength < 0) {
                throw new ProtocolException("negative payload length");
            }
            if (payloadLength > this.maxFramePayloadLength) {
                throw new TooBigException("payload can not be more than " + this.maxFramePayloadLength);
            }
            frame.setPayload(new byte[payloadLength]);
            ptr = 0;
        }
        if (frame.getMask() == null) {
            if ((ptr += this.session.read(this.header, ptr, 4 - ptr)) < 4) {
                this.ptr = ptr;
                return null;
            }
            frame.setMask(Arrays.copyOf(this.header, 4));
            ptr = 0;
        }
        if (ptr < frame.getPayloadLength() && (ptr += this.session.read(frame.getPayload(), ptr, frame.getPayloadLength() - ptr)) < frame.getPayloadLength()) {
            this.ptr = ptr;
            return null;
        }
        this.frame = null;
        this.ptr = 0;
        return frame;
    }

    private Frame createFrame(byte[] header) throws WebSocketException {
        byte b0 = header[0];
        byte b1 = header[1];
        boolean fin = (b0 & 0x80) > 0;
        int rsv = (b0 & 0x70) >>> 4;
        Opcode opcode = Opcode.valueOf(b0 & 0xF);
        int payloadLength = b1 & 0x7F;
        if ((b1 & 0x80) == 0) {
            throw new ProtocolException("not masked");
        }
        if (opcode == null) {
            throw new CannotAcceptException("invalid opcode (" + (b0 & 0xF) + ')');
        }
        if (opcode.isControl()) {
            if (payloadLength > 125) {
                throw new ProtocolException("control payload too big");
            }
            if (!fin) {
                throw new ProtocolException("control payload can not be fragmented");
            }
        }
        return new Frame(fin, opcode, rsv, payloadLength);
    }

    private int byteArrayToInt(byte[] b, int len) {
        int result = 0;
        int shift = 0;
        for (int i = len - 1; i >= 0; --i) {
            result |= (b[i] & 0xFF) << shift;
            shift += 8;
        }
        return result;
    }
}

