/*
 * Decompiled with CFR 0.152.
 */
package one.nio.ws.frame;

import java.io.IOException;
import one.nio.net.Session;
import one.nio.ws.frame.Frame;
import one.nio.ws.frame.Opcode;

public class FrameWriter {
    private final Session session;

    public FrameWriter(Session session) {
        this.session = session;
    }

    public void write(Frame frame) throws IOException {
        byte[] payload = frame.getPayload();
        byte[] header = this.serializeHeader(frame.getRsv(), frame.getOpcode(), payload);
        this.session.write(header, 0, header.length, 32768);
        this.session.write(payload, 0, payload.length);
    }

    private byte[] serializeHeader(int rsv, Opcode opcode, byte[] payload) {
        int len = payload.length < 126 ? 2 : (payload.length < 65536 ? 4 : 10);
        byte[] header = new byte[len];
        header[0] = (byte)(0x80 | rsv << 4 | opcode.value);
        if (payload.length < 126) {
            header[1] = (byte)payload.length;
        } else if (payload.length < 65536) {
            header[1] = 126;
            header[2] = (byte)(payload.length >>> 8);
            header[3] = (byte)(payload.length & 0xFF);
        } else {
            header[1] = 127;
            header[6] = (byte)(payload.length >>> 24);
            header[7] = (byte)(payload.length >>> 16);
            header[8] = (byte)(payload.length >>> 8);
            header[9] = (byte)payload.length;
        }
        return header;
    }
}

