/*
 * Decompiled with CFR 0.152.
 */
package one.nio.ws.frame;

public enum Opcode {
    CONTINUATION(0),
    TEXT(1),
    BINARY(2),
    CLOSE(8),
    PING(9),
    PONG(10);

    private static final Opcode[] VALUES;
    public final byte value;

    private Opcode(int value) {
        this.value = (byte)value;
    }

    public boolean isControl() {
        return (this.value & 8) > 0;
    }

    public boolean isContinuation() {
        return this == CONTINUATION;
    }

    public static Opcode valueOf(int value) {
        return VALUES[value];
    }

    static {
        VALUES = new Opcode[11];
        for (Opcode opcode : Opcode.values()) {
            if (VALUES[opcode.value] != null) {
                throw new IllegalArgumentException("Opcode " + opcode.value + " already used.");
            }
            Opcode.VALUES[opcode.value] = opcode;
        }
    }
}

