/*
 * Decompiled with CFR 0.152.
 */
package one.nio.ws.message;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import one.nio.ws.frame.Opcode;
import one.nio.ws.message.Message;

public class CloseMessage
extends Message<Short> {
    public static final short NORMAL = 1000;
    public static final short GOING_AWAY = 1001;
    public static final short PROTOCOL_ERROR = 1002;
    public static final short CANNOT_ACCEPT = 1003;
    public static final short RESERVED = 1004;
    public static final short NO_STATUS_CODE = 1005;
    public static final short CLOSED_ABNORMALLY = 1006;
    public static final short NOT_CONSISTENT = 1007;
    public static final short VIOLATED_POLICY = 1008;
    public static final short TOO_BIG = 1009;
    public static final short NO_EXTENSION = 1010;
    public static final short UNEXPECTED_CONDITION = 1011;
    public static final short SERVICE_RESTART = 1012;
    public static final short TRY_AGAIN_LATER = 1013;
    public static final short TLS_HANDSHAKE_FAILURE = 1015;

    public CloseMessage(byte[] payload) {
        this(payload.length == 0 ? null : Short.valueOf(ByteBuffer.wrap(payload).order(ByteOrder.LITTLE_ENDIAN).getShort()));
    }

    public CloseMessage(Short code) {
        super(Opcode.CLOSE, code);
    }

    @Override
    public byte[] payload() {
        return new byte[]{(byte)((Short)this.payload & 0xFF), (byte)((Short)this.payload >> 8 & 0xFF)};
    }

    public String toString() {
        return "CloseMessage<" + this.payload + ">";
    }
}

