/*
 * Decompiled with CFR 0.152.
 */
package one.nio.ws.message;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import one.nio.net.Session;
import one.nio.ws.exception.TooBigException;
import one.nio.ws.exception.WebSocketException;
import one.nio.ws.extension.Extension;
import one.nio.ws.frame.Frame;
import one.nio.ws.frame.FrameReader;
import one.nio.ws.frame.Opcode;
import one.nio.ws.message.BinaryMessage;
import one.nio.ws.message.CloseMessage;
import one.nio.ws.message.Message;
import one.nio.ws.message.PingMessage;
import one.nio.ws.message.PongMessage;
import one.nio.ws.message.TextMessage;

public class MessageReader {
    private final FrameReader reader;
    private final List<Extension> extensions;
    private final int maxMessagePayloadLength = Integer.getInteger("one.nio.ws.MAX_MESSAGE_PAYLOAD_LENGTH", 0x1000000);
    private PayloadBuffer buffer;

    public MessageReader(Session session, List<Extension> extensions) {
        this.reader = new FrameReader(session);
        this.extensions = extensions;
    }

    public Message<?> read() throws IOException {
        Frame frame = this.reader.read();
        if (frame == null) {
            return null;
        }
        if (frame.isControl()) {
            return this.createMessage(frame.getOpcode(), this.getPayload(frame));
        }
        if (!frame.isFin()) {
            this.appendFrame(frame);
            return null;
        }
        if (this.buffer != null) {
            this.appendFrame(frame);
            Message<?> message = this.createMessage(this.buffer.getOpcode(), this.buffer.getPayload());
            this.buffer = null;
            return message;
        }
        return this.createMessage(frame.getOpcode(), this.getPayload(frame));
    }

    private void appendFrame(Frame frame) throws IOException {
        if (this.buffer == null) {
            this.buffer = new PayloadBuffer(frame.getOpcode(), this.maxMessagePayloadLength);
        }
        this.buffer.append(this.getPayload(frame));
    }

    private Message<?> createMessage(Opcode opcode, byte[] payload) {
        switch (opcode) {
            case CLOSE: {
                return new CloseMessage(payload);
            }
            case PING: {
                return new PingMessage(payload);
            }
            case PONG: {
                return new PongMessage(payload);
            }
            case BINARY: {
                return new BinaryMessage(payload);
            }
            case TEXT: {
                return new TextMessage(new String(payload, StandardCharsets.UTF_8));
            }
        }
        throw new IllegalArgumentException("Unsupported opcode: " + (Object)((Object)opcode));
    }

    private byte[] getPayload(Frame frame) throws IOException {
        frame.unmask();
        for (Extension extension : this.extensions) {
            extension.transformInput(frame);
        }
        return frame.getPayload();
    }

    public static class PayloadBuffer {
        private final Opcode opcode;
        private final List<byte[]> chunks;
        private final int maxMessagePayloadLength;
        private int payloadLength;

        public PayloadBuffer(Opcode opcode, int maxMessagePayloadLength) {
            this.opcode = opcode;
            this.chunks = new ArrayList<byte[]>();
            this.maxMessagePayloadLength = maxMessagePayloadLength;
        }

        public Opcode getOpcode() {
            return this.opcode;
        }

        public byte[] getPayload() {
            byte[] result = new byte[this.payloadLength];
            int pos = 0;
            for (byte[] chunk : this.chunks) {
                int length = chunk.length;
                System.arraycopy(chunk, 0, result, pos, length);
                pos += length;
            }
            return result;
        }

        public void append(byte[] payload) throws WebSocketException {
            this.payloadLength += payload.length;
            if (this.payloadLength > this.maxMessagePayloadLength) {
                throw new TooBigException("payload can not be more than " + this.maxMessagePayloadLength);
            }
            this.chunks.add(payload);
        }
    }
}

