/*
 * Decompiled with CFR 0.152.
 */
package one.nio.ws.message;

import java.io.IOException;
import java.util.List;
import one.nio.net.Session;
import one.nio.ws.extension.Extension;
import one.nio.ws.frame.Frame;
import one.nio.ws.frame.FrameWriter;
import one.nio.ws.message.Message;

public class MessageWriter {
    private final FrameWriter writer;
    private final List<Extension> extensions;

    public MessageWriter(Session session, List<Extension> extensions) {
        this.writer = new FrameWriter(session);
        this.extensions = extensions;
    }

    public void write(Message<?> message) throws IOException {
        Frame frame = new Frame(message.opcode(), message.payload());
        for (Extension extension : this.extensions) {
            extension.transformOutput(frame);
        }
        this.writer.write(frame);
    }
}

