/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.odkl.hyperopt;

import org.apache.spark.ml.odkl.ModelWithSummary;
import org.apache.spark.ml.odkl.hyperopt.HyperparametersOptimizer;
import org.apache.spark.ml.odkl.hyperopt.HyperparametersOptimizer$;
import org.apache.spark.ml.odkl.hyperopt.HyperparametersOptimizer$$anonfun$6$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.FloatParam;
import org.apache.spark.ml.param.IntArrayParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

public abstract class HyperparametersOptimizer$class {
    public static HyperparametersOptimizer setParamNames(HyperparametersOptimizer $this, Seq value) {
        return (HyperparametersOptimizer)((Params)$this).set($this.paramNames(), (Object)value.toMap(Predef$.MODULE$.$conforms()));
    }

    public static String resolveParamName(HyperparametersOptimizer $this, Param param) {
        return (String)((Params)$this).get($this.paramNames()).flatMap((Function1)new Serializable($this, param){
            public static final long serialVersionUID = 0L;
            private final Param param$1;

            public final Option<String> apply(Map<Param<?>, String> x$1) {
                return x$1.get((Object)this.param$1);
            }
            {
                this.param$1 = param$1;
            }
        }).getOrElse((Function0)new Serializable($this, param){
            public static final long serialVersionUID = 0L;
            private final Param param$1;

            public final String apply() {
                return this.param$1.name();
            }
            {
                this.param$1 = param$1;
            }
        });
    }

    public static String getMetricsBlock(HyperparametersOptimizer $this) {
        return (String)((Params)$this).$($this.metricsBlock());
    }

    public static HyperparametersOptimizer setMetricsBlock(HyperparametersOptimizer $this, String value) {
        return (HyperparametersOptimizer)((Params)$this).set($this.metricsBlock(), (Object)value);
    }

    public static String getMetricsExpression(HyperparametersOptimizer $this) {
        return (String)((Params)$this).$($this.metricsExpression());
    }

    public static HyperparametersOptimizer setMetricsExpression(HyperparametersOptimizer $this, String value) {
        return (HyperparametersOptimizer)((Params)$this).set($this.metricsExpression(), (Object)value);
    }

    public static String getConfigurationIndexColumn(HyperparametersOptimizer $this) {
        return (String)((Params)$this).$($this.configurationIndexColumn());
    }

    public static HyperparametersOptimizer setConfigurationIndexColumn(HyperparametersOptimizer $this, String value) {
        return (HyperparametersOptimizer)((Params)$this).set($this.configurationIndexColumn(), (Object)value);
    }

    public static String getResultingMetricColumn(HyperparametersOptimizer $this) {
        return (String)((Params)$this).$($this.resultingMetricColumn());
    }

    public static HyperparametersOptimizer setResultingMetricColumn(HyperparametersOptimizer $this, String value) {
        return (HyperparametersOptimizer)((Params)$this).set($this.resultingMetricColumn(), (Object)value);
    }

    public static Tuple3 extractParamsAndQuality(HyperparametersOptimizer $this, ParamMap params, ModelWithSummary model) {
        Dataset metrics = (Dataset)model.summary().blocks().apply((Object)new ModelWithSummary.Block((String)((Params)$this).$($this.metricsBlock())));
        String tableName = new StringBuilder().append((Object)((Identifiable)model).uid()).append((Object)"_metrics").toString();
        String query = ((String)((Params)$this).$($this.metricsExpression())).replaceAll("__THIS__", tableName);
        metrics.createOrReplaceTempView(tableName);
        double quality = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])metrics.sqlContext().sql(query).rdd().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Number apply(Row x$2) {
                return (Number)x$2.getAs(0);
            }
        }, ClassTag$.MODULE$.apply(Number.class)).collect()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final double apply(Number x$3) {
                return x$3.doubleValue();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return new Tuple3((Object)params, (Object)model, (Object)BoxesRunTime.boxToDouble((double)quality));
    }

    public static ModelWithSummary extractBestModel(HyperparametersOptimizer $this, SQLContext sqlContext, Seq failedModels, Seq rankedModels) {
        Dataset<Row> configurationBlock = $this.createConfigurationsBlock(sqlContext, failedModels, rankedModels);
        ModelWithSummary bestModel = (ModelWithSummary)((Tuple3)rankedModels.head())._2();
        Map nestedBlocks = ((TraversableOnce)bestModel.summary().blocks().keys().map((Function1)new Serializable($this, rankedModels){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HyperparametersOptimizer $outer;
            private final Seq rankedModels$1;

            public final Tuple2<ModelWithSummary.Block, Dataset<Row>> apply(ModelWithSummary.Block block) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)block), ((TraversableOnce)((TraversableLike)this.rankedModels$1.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, block){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HyperparametersOptimizer$.anonfun.3 $outer;
                    private final ModelWithSummary.Block block$1;

                    public final Dataset<Row> apply(Tuple2<Tuple3<ParamMap, M, Object>, Object> x) {
                        return ((ModelWithSummary)((Tuple3)x._1())._2()).summary().apply(this.block$1).withColumn((String)((Params)this.$outer.org$apache$spark$ml$odkl$hyperopt$HyperparametersOptimizer$$anonfun$$$outer()).$(this.$outer.org$apache$spark$ml$odkl$hyperopt$HyperparametersOptimizer$$anonfun$$$outer().configurationIndexColumn()), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)x._2$mcI$sp())));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.block$1 = block$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Dataset<Row> apply(Dataset<Row> x$4, Dataset<Row> x$5) {
                        return x$4.union(x$5);
                    }
                }));
            }

            public /* synthetic */ HyperparametersOptimizer org$apache$spark$ml$odkl$hyperopt$HyperparametersOptimizer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rankedModels$1 = rankedModels$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.configurations()), configurationBlock)})));
        return bestModel.copy((Map<ModelWithSummary.Block, Dataset<Row>>)nestedBlocks, bestModel.copy$default$2());
    }

    public static Dataset createConfigurationsBlock(HyperparametersOptimizer $this, SQLContext sqlContext, Seq failedModels, Seq rankedModels) {
        Seq keys = (Seq)((SeqLike)((ParamMap)((Tuple3)rankedModels.head())._1()).toSeq().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Param<Object> apply(ParamPair<?> x$6) {
                return x$6.param();
            }
        }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Param<Object> x$7) {
                return x$7.name();
            }
        }, (Ordering)Ordering.String$.MODULE$);
        StructType schema = StructType$.MODULE$.apply((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField((String)((Params)$this).$($this.configurationIndexColumn()), (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField((String)((Params)$this).$($this.resultingMetricColumn()), (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField((String)((Params)$this).$($this.errorColumn()), (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).$plus$plus((GenTraversableOnce)keys.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HyperparametersOptimizer $outer;

            public final StructField apply(Param<?> x) {
                Param<?> param = x;
                Object object = param instanceof IntParam ? IntegerType$.MODULE$ : (param instanceof DoubleParam ? DoubleType$.MODULE$ : (param instanceof LongParam ? LongType$.MODULE$ : (param instanceof BooleanParam ? BooleanType$.MODULE$ : (param instanceof FloatParam ? FloatType$.MODULE$ : (param instanceof StringArrayParam ? new ArrayType((DataType)StringType$.MODULE$, true) : (param instanceof DoubleArrayParam ? new ArrayType((DataType)DoubleType$.MODULE$, true) : (param instanceof IntArrayParam ? new ArrayType((DataType)IntegerType$.MODULE$, true) : StringType$.MODULE$)))))));
                IntegerType$ dataType = object;
                return new StructField((String)((Params)this.$outer).get(this.$outer.paramNames()).map((Function1)new Serializable(this, x){
                    public static final long serialVersionUID = 0L;
                    public final Param x$10;

                    public final String apply(Map<Param<?>, String> x$8) {
                        return (String)x$8.getOrElse((Object)this.x$10, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ HyperparametersOptimizer$$anonfun$6$.anonfun.apply.3 $outer;

                            public final String apply() {
                                return this.$outer.x$10.toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.x$10 = x$10;
                    }
                }).getOrElse((Function0)new Serializable(this, x){
                    public static final long serialVersionUID = 0L;
                    private final Param x$10;

                    public final String apply() {
                        return this.x$10.toString();
                    }
                    {
                        this.x$10 = x$10;
                    }
                }), (DataType)dataType, true, StructField$.MODULE$.apply$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()));
        Seq rows = (Seq)((TraversableLike)((TraversableLike)rankedModels.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this, keys){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HyperparametersOptimizer $outer;
            private final Seq keys$1;

            public final Row apply(Tuple2<Tuple3<ParamMap, M, Object>, Object> x) {
                int index = x._2$mcI$sp();
                ParamMap params = (ParamMap)((Tuple3)x._1())._1();
                double metric = BoxesRunTime.unboxToDouble((Object)((Tuple3)x._1())._3());
                return Row$.MODULE$.fromSeq((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index), BoxesRunTime.boxToDouble((double)metric), ""}))).$plus$plus((GenTraversableOnce)HyperparametersOptimizer$class.extractParams$1(this.$outer, params, this.keys$1), Seq$.MODULE$.canBuildFrom()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keys$1 = keys$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)((TraversableLike)failedModels.filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<ParamMap, Try<M>> x$9) {
                return ((Try)x$9._2()).isFailure();
            }
        })).map((Function1)new Serializable($this, keys){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HyperparametersOptimizer $outer;
            private final Seq keys$1;

            public final Row apply(Tuple2<ParamMap, Try<M>> x) {
                ParamMap params = (ParamMap)x._1();
                String error = ((Throwable)((Try)x._2()).failed().get()).toString();
                return Row$.MODULE$.fromSeq((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToDouble((double)Double.NaN), error}))).$plus$plus((GenTraversableOnce)HyperparametersOptimizer$class.extractParams$1(this.$outer, params, this.keys$1), Seq$.MODULE$.canBuildFrom()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keys$1 = keys$1;
            }
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Dataset configurationBlock = sqlContext.createDataFrame(sqlContext.sparkContext().parallelize(rows, 1, ClassTag$.MODULE$.apply(Row.class)), schema);
        return configurationBlock;
    }

    public static Tuple2 extractConfig(HyperparametersOptimizer $this, ModelWithSummary model) {
        Row row = (Row)Predef$.MODULE$.refArrayOps((Object[])model.summary().apply($this.configurations()).collect()).head();
        return $this.extractConfig(row);
    }

    public static final Seq extractParams$1(HyperparametersOptimizer $this, ParamMap params, Seq keys$1) {
        return (Seq)keys$1.map((Function1)new Serializable($this, params){
            public static final long serialVersionUID = 0L;
            private final ParamMap params$1;

            public final Object apply(Param<?> key) {
                return this.params$1.get(key).map((Function1)new Serializable(this, key){
                    public static final long serialVersionUID = 0L;
                    private final Param key$1;

                    public final Object apply(Object value) {
                        Object object;
                        Param param = this.key$1;
                        boolean bl = param instanceof IntParam ? true : (param instanceof DoubleParam ? true : (param instanceof LongParam ? true : (param instanceof BooleanParam ? true : param instanceof FloatParam)));
                        if (bl) {
                            object = value;
                        } else {
                            boolean bl2 = param instanceof StringArrayParam ? true : (param instanceof DoubleArrayParam ? true : param instanceof IntArrayParam);
                            object = bl2 ? value : this.key$1.jsonEncode(value);
                        }
                        return object;
                    }
                    {
                        this.key$1 = key$1;
                    }
                }).get();
            }
            {
                this.params$1 = params$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static void $init$(HyperparametersOptimizer $this) {
        $this.org$apache$spark$ml$odkl$hyperopt$HyperparametersOptimizer$_setter_$paramNames_$eq(new Param((Identifiable)$this, "paramsFriendlyNames", "Names of the parameters to use in column names to store configs"));
        $this.org$apache$spark$ml$odkl$hyperopt$HyperparametersOptimizer$_setter_$metricsBlock_$eq(new Param((Identifiable)$this, "metricsBlock", "Name of the block with metrics to get results from."));
        $this.org$apache$spark$ml$odkl$hyperopt$HyperparametersOptimizer$_setter_$metricsExpression_$eq(new Param((Identifiable)$this, "metricsExpression", "Expression used to extract single metric value from the metrics table. __THIS__ shoud be used as a table alias."));
        $this.org$apache$spark$ml$odkl$hyperopt$HyperparametersOptimizer$_setter_$configurationIndexColumn_$eq(new Param((Identifiable)$this, "configurationIndexColumn", "Name of the column to store id of config for further analysis."));
        $this.org$apache$spark$ml$odkl$hyperopt$HyperparametersOptimizer$_setter_$resultingMetricColumn_$eq(new Param((Identifiable)$this, "resultingMetricColumn", "Name of the column to store resulting metrics for further analysis."));
        $this.org$apache$spark$ml$odkl$hyperopt$HyperparametersOptimizer$_setter_$errorColumn_$eq(new Param((Identifiable)$this, "errorColumn", "Name of the column to store text of the error if occurs."));
        ((Params)$this).setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.metricsBlock().$minus$greater((Object)"metrics"), $this.configurationIndexColumn().$minus$greater((Object)"configurationIndex"), $this.resultingMetricColumn().$minus$greater((Object)"resultingMetric"), $this.errorColumn().$minus$greater((Object)"error")}));
    }
}

