/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.photon.ml.hyperparameter.estimators.kernels;

import breeze.generic.UFunc;
import breeze.linalg.$times$;
import breeze.linalg.BitVector$;
import breeze.linalg.BroadcastedRows$;
import breeze.linalg.Broadcaster$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.NumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.any$;
import breeze.linalg.cholesky;
import breeze.linalg.cholesky$;
import breeze.linalg.diag$;
import breeze.linalg.package;
import breeze.linalg.squaredDistance$;
import breeze.linalg.sum$;
import breeze.math.Semiring$;
import breeze.numerics.package;
import breeze.storage.Zero;
import com.linkedin.photon.ml.hyperparameter.estimators.kernels.Kernel;
import com.linkedin.photon.ml.hyperparameter.estimators.kernels.Kernel$class;
import com.linkedin.photon.ml.hyperparameter.estimators.kernels.StationaryKernel$;
import com.linkedin.photon.ml.util.Linalg$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001}4Q!\u0001\u0002\u0002\u0002E\u0011\u0001c\u0015;bi&|g.\u0019:z\u0017\u0016\u0014h.\u001a7\u000b\u0005\r!\u0011aB6fe:,Gn\u001d\u0006\u0003\u000b\u0019\t!\"Z:uS6\fGo\u001c:t\u0015\t9\u0001\"\u0001\bisB,'\u000f]1sC6,G/\u001a:\u000b\u0005%Q\u0011AA7m\u0015\tYA\"\u0001\u0004qQ>$xN\u001c\u0006\u0003\u001b9\t\u0001\u0002\\5oW\u0016$\u0017N\u001c\u0006\u0002\u001f\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\tI\"$D\u0001\u0003\u0013\tY\"A\u0001\u0004LKJtW\r\u001c\u0005\t;\u0001\u0011\t\u0011)A\u0005=\u0005I\u0011-\u001c9mSR,H-\u001a\t\u0003'}I!\u0001\t\u000b\u0003\r\u0011{WO\u00197f\u0011!\u0011\u0003A!A!\u0002\u0013q\u0012!\u00028pSN,\u0007\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u00171,gn\u001a;i'\u000e\fG.\u001a\t\u0004M-rR\"A\u0014\u000b\u0005!J\u0013A\u00027j]\u0006dwMC\u0001+\u0003\u0019\u0011'/Z3{K&\u0011Af\n\u0002\f\t\u0016t7/\u001a,fGR|'\u000fC\u0003/\u0001\u0011\u0005q&\u0001\u0004=S:LGO\u0010\u000b\u0005aE\u00124\u0007\u0005\u0002\u001a\u0001!9Q$\fI\u0001\u0002\u0004q\u0002b\u0002\u0012.!\u0003\u0005\rA\b\u0005\bI5\u0002\n\u00111\u0001&\u0011\u001d)\u0004A1A\u0005\u0002Y\na\"Y7qY&$X\u000fZ3TG\u0006dW-F\u0001\u001f\u0011\u0019A\u0004\u0001)A\u0005=\u0005y\u0011-\u001c9mSR,H-Z*dC2,\u0007\u0005C\u0004;\u0001\t\u0007I\u0011\u0001\u001c\u0002\u00159|\u0017n]3TG\u0006dW\r\u0003\u0004=\u0001\u0001\u0006IAH\u0001\f]>L7/Z*dC2,\u0007\u0005C\u0004?\u0001\t\u0007I\u0011\u0001\u001c\u0002\u001d1,gn\u001a;i'\u000e\fG.Z'bq\"1\u0001\t\u0001Q\u0001\ny\tq\u0002\\3oORD7kY1mK6\u000b\u0007\u0010\t\u0005\u0007\u0005\u00021\tBA\"\u0002+\u0019\u0014x.\u001c)bSJ<\u0018n]3ESN$\u0018M\\2fgR\u0011Ai\u0012\t\u0004M\u0015s\u0012B\u0001$(\u0005-!UM\\:f\u001b\u0006$(/\u001b=\t\u000b!\u000b\u0005\u0019\u0001#\u0002\u000b\u0011L7\u000f^:\t\u000b)\u0003A\u0011I&\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005\u0011c\u0005\"B'J\u0001\u0004!\u0015!\u0001=\t\u000b)\u0003A\u0011I(\u0015\u0007\u0011\u0003&\u000bC\u0003R\u001d\u0002\u0007A)\u0001\u0002yc!)1K\u0014a\u0001\t\u0006\u0011\u0001P\r\u0005\u0006+\u0002!\tEV\u0001\nO\u0016$\b+\u0019:b[N,\u0012!\n\u0005\u00061\u0002!\t%W\u0001\u000eY><G*[6fY&Dwn\u001c3\u0015\u0007yQ6\fC\u0003N/\u0002\u0007A\tC\u0003]/\u0002\u0007Q%A\u0001z\u0011\u0019q\u0006\u0001\"\u0005\u0003?\u0006\t\u0002/Y5so&\u001cX\rR5ti\u0006t7-Z:\u0015\u0005\u0011\u0003\u0007\"B'^\u0001\u0004!\u0005B\u00020\u0001\t#\u0011!\rF\u0002EG\u0012DQ!U1A\u0002\u0011CQaU1A\u0002\u0011;qA\u001a\u0002\u0002\u0002#\u0005q-\u0001\tTi\u0006$\u0018n\u001c8bef\\UM\u001d8fYB\u0011\u0011\u0004\u001b\u0004\b\u0003\t\t\t\u0011#\u0001j'\tA'\u0003C\u0003/Q\u0012\u00051\u000eF\u0001h\u0011\u001di\u0007.%A\u0005\u00029\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nT#A8+\u0005y\u00018&A9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018!C;oG\",7m[3e\u0015\t1H#\u0001\u0006b]:|G/\u0019;j_:L!\u0001_:\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004{QF\u0005I\u0011\u00018\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0011\u001da\b.%A\u0005\u0002u\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aT#\u0001@+\u0005\u0015\u0002\b")
public abstract class StationaryKernel
implements Kernel {
    private final double amplitude;
    private final double noise;
    private final DenseVector<Object> lengthScale;
    private final double amplitudeScale;
    private final double noiseScale;
    private final double lengthScaleMax;

    public static DenseVector<Object> $lessinit$greater$default$3() {
        return StationaryKernel$.MODULE$.$lessinit$greater$default$3();
    }

    public static double $lessinit$greater$default$2() {
        return StationaryKernel$.MODULE$.$lessinit$greater$default$2();
    }

    public static double $lessinit$greater$default$1() {
        return StationaryKernel$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public DenseVector<Object> expandDimensions(DenseVector<Object> param, int dim) {
        return Kernel$class.expandDimensions(this, param, dim);
    }

    public double amplitudeScale() {
        return this.amplitudeScale;
    }

    public double noiseScale() {
        return this.noiseScale;
    }

    public double lengthScaleMax() {
        return this.lengthScaleMax;
    }

    public abstract DenseMatrix<Object> fromPairwiseDistances(DenseMatrix<Object> var1);

    @Override
    public DenseMatrix<Object> apply(DenseMatrix<Object> x) {
        Predef$.MODULE$.require(x.rows() > 0 && x.cols() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Empty input.";
            }
        });
        DenseVector<Object> ls = this.expandDimensions(this.lengthScale, x.cols());
        DenseMatrix<Object> dists = this.pairwiseDistances((DenseMatrix<Object>)((DenseMatrix)((ImmutableNumericOps)x.apply((Object)$times$.MODULE$, (Object)package$.MODULE$.$colon$colon(), Broadcaster$.MODULE$.canBroadcastRows(DenseMatrix$.MODULE$.handholdCanMapCols()))).$div(ls, BroadcastedRows$.MODULE$.broadcastOp2(DenseMatrix$.MODULE$.handholdCanMapCols(), DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv(), DenseMatrix$.MODULE$.canMapCols(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$, DenseVector$.MODULE$.dv_dv_UpdateOp_Double_OpSet())))));
        return (DenseMatrix)((NumericOps)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)this.amplitude))).$times(this.fromPairwiseDistances(dists), DenseMatrix$.MODULE$.s_dm_op_Double_OpMulMatrix())).$plus(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)this.noise))).$times((Object)DenseMatrix$.MODULE$.eye$mDc$sp(x.rows(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$, Semiring$.MODULE$.semiringD()), DenseMatrix$.MODULE$.s_dm_op_Double_OpMulMatrix()), DenseMatrix$.MODULE$.op_DM_DM_Double_OpAdd());
    }

    @Override
    public DenseMatrix<Object> apply(DenseMatrix<Object> x1, DenseMatrix<Object> x2) {
        Predef$.MODULE$.require(x1.rows() > 0 && x1.cols() > 0 && x2.rows() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Empty input.";
            }
        });
        Predef$.MODULE$.require(x1.cols() == x2.cols(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Inputs must have the same number of columns";
            }
        });
        DenseVector<Object> ls = this.expandDimensions(this.lengthScale, x1.cols());
        DenseMatrix<Object> dists = this.pairwiseDistances((DenseMatrix<Object>)((DenseMatrix)((ImmutableNumericOps)x1.apply((Object)$times$.MODULE$, (Object)package$.MODULE$.$colon$colon(), Broadcaster$.MODULE$.canBroadcastRows(DenseMatrix$.MODULE$.handholdCanMapCols()))).$div(ls, BroadcastedRows$.MODULE$.broadcastOp2(DenseMatrix$.MODULE$.handholdCanMapCols(), DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv(), DenseMatrix$.MODULE$.canMapCols(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$, DenseVector$.MODULE$.dv_dv_UpdateOp_Double_OpSet())))), (DenseMatrix<Object>)((DenseMatrix)((ImmutableNumericOps)x2.apply((Object)$times$.MODULE$, (Object)package$.MODULE$.$colon$colon(), Broadcaster$.MODULE$.canBroadcastRows(DenseMatrix$.MODULE$.handholdCanMapCols()))).$div(ls, BroadcastedRows$.MODULE$.broadcastOp2(DenseMatrix$.MODULE$.handholdCanMapCols(), DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv(), DenseMatrix$.MODULE$.canMapCols(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$, DenseVector$.MODULE$.dv_dv_UpdateOp_Double_OpSet())))));
        return (DenseMatrix)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)this.amplitude))).$times(this.fromPairwiseDistances(dists), DenseMatrix$.MODULE$.s_dm_op_Double_OpMulMatrix());
    }

    @Override
    public DenseVector<Object> getParams() {
        return DenseVector$.MODULE$.vertcat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DenseVector[]{(DenseVector)DenseVector$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{this.amplitude, this.noise}), ClassTag$.MODULE$.Double()), this.lengthScale}), DenseVector$.MODULE$.dv_dv_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
    }

    @Override
    public double logLikelihood(DenseMatrix<Object> x, DenseVector<Object> y) {
        double d;
        if (this.amplitude < 0.0 || this.noise < 0.0 || BoxesRunTime.unboxToBoolean((Object)any$.MODULE$.apply(this.lengthScale.$colon$less((Object)BoxesRunTime.boxToDouble((double)0.0), DenseVector$.MODULE$.dv_s_CompOp_Double_OpLT()), (UFunc.UImpl)BitVector$.MODULE$.anyImpl()))) {
            return Double.NEGATIVE_INFINITY;
        }
        if (BoxesRunTime.unboxToBoolean((Object)any$.MODULE$.apply(this.lengthScale.$colon$greater((Object)BoxesRunTime.boxToDouble((double)this.lengthScaleMax()), DenseVector$.MODULE$.dv_s_CompOp_Double_OpGT()), (UFunc.UImpl)BitVector$.MODULE$.anyImpl()))) {
            return Double.NEGATIVE_INFINITY;
        }
        DenseMatrix<Object> k = this.apply(x);
        try {
            DenseMatrix l = (DenseMatrix)cholesky$.MODULE$.apply(k, (UFunc.UImpl)cholesky.ImplCholesky_DM$.MODULE$);
            DenseVector<Object> alpha = Linalg$.MODULE$.choleskySolve((DenseMatrix<Object>)l, y);
            double likelihood = -0.5 * BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)y.t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms()))).$times(alpha, Transpose$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)DenseVector.canDotD$.MODULE$))) - BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(package.log$.MODULE$.apply(diag$.MODULE$.apply((Object)l, diag$.MODULE$.diagDMDVImpl()), package.log$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.log$.logDoubleImpl$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))) - (double)k.rows() / 2.0 * package.log$.MODULE$.apply$mDDc$sp((double)2 * breeze.numerics.constants.package$.MODULE$.Pi(), (UFunc.UImpl)package.log$.logDoubleImpl$.MODULE$);
            d = likelihood + -0.5 * package.pow$.MODULE$.apply$mDIDc$sp(package.log$.MODULE$.apply$mDDc$sp(package.sqrt$.MODULE$.apply$mDDc$sp(this.amplitude / this.amplitudeScale(), (UFunc.UImpl)package.sqrt$.sqrtDoubleImpl$.MODULE$), (UFunc.UImpl)package.log$.logDoubleImpl$.MODULE$), 2, (UFunc.UImpl2)package.pow$.powDoubleIntImpl$.MODULE$) + (this.noise > 0.0 ? package.log$.MODULE$.apply$mDDc$sp(package.log$.MODULE$.apply$mDDc$sp(1.0 + package.pow$.MODULE$.apply$mDIDc$sp(this.noiseScale() / this.noise, 2, (UFunc.UImpl2)package.pow$.powDoubleIntImpl$.MODULE$), (UFunc.UImpl)package.log$.logDoubleImpl$.MODULE$), (UFunc.UImpl)package.log$.logDoubleImpl$.MODULE$) : 0.0);
        }
        catch (Exception exception) {
            d = Double.NEGATIVE_INFINITY;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public DenseMatrix<Object> pairwiseDistances(DenseMatrix<Object> x) {
        void var2_2;
        DenseMatrix out = DenseMatrix$.MODULE$.zeros$mDc$sp(x.rows(), x.rows(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), x.rows()).foreach$mVc$sp((Function1)new Serializable(this, x, out){
            public static final long serialVersionUID = 0L;
            public final DenseMatrix x$1;
            public final DenseMatrix out$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), i).foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$pairwiseDistances$1 $outer;
                    private final int i$1;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        double dist = BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply(((ImmutableNumericOps)this.$outer.x$1.apply((Object)BoxesRunTime.boxToInteger((int)this.i$1), (Object)package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).t(Transpose$.MODULE$.canUntranspose()), ((ImmutableNumericOps)this.$outer.x$1.apply((Object)BoxesRunTime.boxToInteger((int)j), (Object)package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).t(Transpose$.MODULE$.canUntranspose()), squaredDistance$.MODULE$.squaredDistanceFromZippedValues(DenseVector$.MODULE$.canZipValues_DV_DV_Double())));
                        this.$outer.out$1.update$mcD$sp(this.i$1, j, dist);
                        this.$outer.out$1.update$mcD$sp(j, this.i$1, dist);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                });
            }
            {
                this.x$1 = x$1;
                this.out$1 = out$1;
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public DenseMatrix<Object> pairwiseDistances(DenseMatrix<Object> x1, DenseMatrix<Object> x2) {
        void var3_3;
        DenseMatrix out = DenseMatrix$.MODULE$.zeros$mDc$sp(x1.rows(), x2.rows(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), x1.rows()).foreach$mVc$sp((Function1)new Serializable(this, x1, x2, out){
            public static final long serialVersionUID = 0L;
            public final DenseMatrix x1$1;
            public final DenseMatrix x2$1;
            public final DenseMatrix out$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.x2$1.rows()).foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$pairwiseDistances$2 $outer;
                    private final int i$2;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        this.$outer.out$2.update$mcD$sp(this.i$2, j, BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply(((ImmutableNumericOps)this.$outer.x1$1.apply((Object)BoxesRunTime.boxToInteger((int)this.i$2), (Object)package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).t(Transpose$.MODULE$.canUntranspose()), ((ImmutableNumericOps)this.$outer.x2$1.apply((Object)BoxesRunTime.boxToInteger((int)j), (Object)package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).t(Transpose$.MODULE$.canUntranspose()), squaredDistance$.MODULE$.squaredDistanceFromZippedValues(DenseVector$.MODULE$.canZipValues_DV_DV_Double()))));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$2 = i$2;
                    }
                });
            }
            {
                this.x1$1 = x1$1;
                this.x2$1 = x2$1;
                this.out$2 = out$2;
            }
        });
        return var3_3;
    }

    public StationaryKernel(double amplitude, double noise, DenseVector<Object> lengthScale) {
        this.amplitude = amplitude;
        this.noise = noise;
        this.lengthScale = lengthScale;
        Kernel$class.$init$(this);
        this.amplitudeScale = 1.0;
        this.noiseScale = 0.1;
        this.lengthScaleMax = 2.0;
    }
}

