/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.odkl;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.odkl.Evaluator;
import org.apache.spark.ml.odkl.JacksonParam$;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.odkl.SparkSqlUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0001\u0003\u00015\u0011QDQ5oCJL8\t\\1tg&4\u0017nY1uS>tWI^1mk\u0006$xN\u001d\u0006\u0003\u0007\u0011\tAa\u001c3lY*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002E\u0002\u0010!Ii\u0011AA\u0005\u0003#\t\u0011\u0011\"\u0012<bYV\fGo\u001c:\u0011\u0005=\u0001\u0001\u0002\u0003\u000b\u0001\u0005\u000b\u0007I\u0011I\u000b\u0002\u0007ULG-F\u0001\u0017!\t9RD\u0004\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012$\u0001\u0004Qe\u0016$WMZ\u0005\u0003=}\u0011aa\u0015;sS:<'B\u0001\u000f\u001a\u0011%\t\u0003A!A!\u0002\u00131\"%\u0001\u0003vS\u0012\u0004\u0013B\u0001\u000b\u0011\u0011\u0015!\u0003\u0001\"\u0001&\u0003\u0019a\u0014N\\5u}Q\u0011!C\n\u0005\u0006)\r\u0002\rA\u0006\u0005\u0006I\u0001!\t\u0001\u000b\u000b\u0002%!9!\u0006\u0001b\u0001\n\u0003Y\u0013a\u00049sK\u0012L7\r^5p]&sG-\u001a=\u0016\u00031\u0002\"!\f\u0019\u000e\u00039R!a\f\u0003\u0002\u000bA\f'/Y7\n\u0005Er#\u0001C%oiB\u000b'/Y7\t\rM\u0002\u0001\u0015!\u0003-\u0003A\u0001(/\u001a3jGRLwN\\%oI\u0016D\b\u0005C\u00036\u0001\u0011\u0005a'\u0001\ntKR\u0004&/\u001a3jGRLwN\\%oI\u0016DHCA\u001c9\u001b\u0005\u0001\u0001\"B\u001d5\u0001\u0004Q\u0014!\u0002<bYV,\u0007C\u0001\r<\u0013\ta\u0014DA\u0002J]RDQA\u0010\u0001\u0005\u0002}\n!cZ3u!J,G-[2uS>t\u0017J\u001c3fqV\t!\bC\u0004B\u0001\t\u0007I\u0011\u0001\"\u0002%\u0019lW-Y:ve\u0016$\u0006N]3tQ>dGm]\u000b\u0002\u0007B\u0019Q\u0006\u0012$\n\u0005\u0015s#!\u0002)be\u0006l\u0007\u0003B\fH-%K!\u0001S\u0010\u0003\u00075\u000b\u0007\u000f\u0005\u0002\u0019\u0015&\u00111*\u0007\u0002\u0007\t>,(\r\\3\t\r5\u0003\u0001\u0015!\u0003D\u0003M1W.Z1tkJ,G\u000b\u001b:fg\"|G\u000eZ:!\u0011\u0015y\u0005\u0001\"\u0001Q\u0003U\u0019X\r\u001e$nK\u0006\u001cXO]3UQJ,7\u000f[8mIN$\"aN)\t\u000ber\u0005\u0019\u0001$\t\u000bM\u0003A\u0011\u0001+\u0002+\u001d,GOR7fCN,(/\u001a+ie\u0016\u001c\bn\u001c7egV\ta\tC\u0004W\u0001\t\u0007IQA\u0016\u0002\u000f9,XNQ5og\"1\u0001\f\u0001Q\u0001\u000e1\n\u0001B\\;n\u0005&t7\u000f\t\u0005\u00065\u0002!\teW\u0001\niJ\fgn\u001d4pe6$\"\u0001\u00189\u0011\u0005ukgB\u00010k\u001d\ty\u0006N\u0004\u0002aO:\u0011\u0011M\u001a\b\u0003E\u0016l\u0011a\u0019\u0006\u0003I2\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\tIg!A\u0002tc2L!a\u001b7\u0002\u000fA\f7m[1hK*\u0011\u0011NB\u0005\u0003]>\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005-d\u0007\"B9Z\u0001\u0004\u0011\u0018a\u00023bi\u0006\u001cX\r\u001e\u0019\u0003gf\u00042\u0001^;x\u001b\u0005a\u0017B\u0001<m\u0005\u001d!\u0015\r^1tKR\u0004\"\u0001_=\r\u0001\u0011I!\u0010]A\u0001\u0002\u0003\u0015\ta\u001f\u0002\u0004?\u0012\n\u0014C\u0001?\u0000!\tAR0\u0003\u0002\u007f3\t9aj\u001c;iS:<\u0007c\u0001\r\u0002\u0002%\u0019\u00111A\r\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\b\u0001!\t%!\u0003\u0002\t\r|\u0007/\u001f\u000b\u0004%\u0005-\u0001\u0002CA\u0007\u0003\u000b\u0001\r!a\u0004\u0002\u000b\u0015DHO]1\u0011\u00075\n\t\"C\u0002\u0002\u00149\u0012\u0001\u0002U1sC6l\u0015\r\u001d\u0005\b\u0003/\u0001A\u0011IA\r\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BA\u000e\u0003O\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003Ca\u0017!\u0002;za\u0016\u001c\u0018\u0002BA\u0013\u0003?\u0011!b\u0015;sk\u000e$H+\u001f9f\u0011!\tI#!\u0006A\u0002\u0005m\u0011AB:dQ\u0016l\u0017\r\u000b\u0003\u0002\u0016\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005Mb!\u0001\u0006b]:|G/\u0019;j_:LA!a\u000e\u00022\taA)\u001a<fY>\u0004XM]!qS\u0002")
public class BinaryClassificationEvaluator
extends Evaluator<BinaryClassificationEvaluator> {
    private final IntParam predictionIndex = new IntParam((Identifiable)this, "predictionIndex", "Select value by that index from probability vector.");
    private final Param<Map<String, Object>> fmeasureThresholds;
    private final IntParam numBins;

    @Override
    public String uid() {
        return super.uid();
    }

    public IntParam predictionIndex() {
        return this.predictionIndex;
    }

    public BinaryClassificationEvaluator setPredictionIndex(int value) {
        return (BinaryClassificationEvaluator)this.set((Param)this.predictionIndex(), BoxesRunTime.boxToInteger((int)value));
    }

    public int getPredictionIndex() {
        return BoxesRunTime.unboxToInt((Object)this.$((Param)this.predictionIndex()));
    }

    public Param<Map<String, Object>> fmeasureThresholds() {
        return this.fmeasureThresholds;
    }

    public BinaryClassificationEvaluator setFmeasureThresholds(Map<String, Object> value) {
        return (BinaryClassificationEvaluator)this.set(this.fmeasureThresholds(), value);
    }

    public Map<String, Object> getFmeasureThresholds() {
        return (Map)this.$(this.fmeasureThresholds());
    }

    public final IntParam numBins() {
        return this.numBins;
    }

    public Dataset<Row> transform(Dataset<?> dataset) {
        DataType dataType = dataset.schema().apply((String)this.$(this.predictionCol())).dataType();
        RDD rDD = dataType instanceof VectorUDT ? dataset.select((String)this.$(this.predictionCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.$(this.labelCol())})).rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BinaryClassificationEvaluator $outer;

            public final Tuple2<Object, Object> apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object score = ((SeqLike)some.get()).apply(0);
                    Object label = ((SeqLike)some.get()).apply(1);
                    if (score instanceof Vector) {
                        Vector vector = (Vector)score;
                        if (label instanceof Double) {
                            double d = BoxesRunTime.unboxToDouble((Object)label);
                            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(vector.apply(BoxesRunTime.unboxToInt((Object)this.$outer.$((Param)this.$outer.predictionIndex()))), d);
                            return sp2;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)) : dataset.select((String)this.$(this.predictionCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.$(this.labelCol())})).rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Row x0$2) {
                Row row = x0$2;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object score = ((SeqLike)some.get()).apply(0);
                    Object label = ((SeqLike)some.get()).apply(1);
                    if (score instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)score);
                        if (label instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)label);
                            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
                            return sp2;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD predictions = rDD;
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(predictions, 100);
        RDD rows = metrics.roc().count() > 2L ? dataset.sqlContext().sparkContext().parallelize((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"auc", BoxesRunTime.boxToDouble((double)metrics.areaUnderROC()), null, null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"auc_pr", BoxesRunTime.boxToDouble((double)metrics.areaUnderPR()), null, null}))}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])((RDD)((TraversableOnce)((TraversableLike)this.$(this.fmeasureThresholds())).map((Function1)new Serializable(this, metrics){
            public static final long serialVersionUID = 0L;
            private final BinaryClassificationMetrics metrics$1;

            public final RDD<Seq<Object>> apply(Tuple2<String, Object> x0$3) {
                Tuple2<String, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    double threshold = tuple2._2$mcD$sp();
                    RDD rDD = this.metrics$1.fMeasureByThreshold(threshold).map((Function1)new Serializable(this, name){
                        public static final long serialVersionUID = 0L;
                        private final String name$1;

                        public final Seq<Object> apply(Tuple2<Object, Object> x) {
                            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1, BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "threshold", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
                        }
                        {
                            this.name$1 = name$1;
                        }
                    }, ClassTag$.MODULE$.apply(Seq.class));
                    return rDD;
                }
                throw new MatchError(tuple2);
            }
            {
                this.metrics$1 = metrics$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RDD<Seq<Object>> apply(RDD<Seq<Object>> x$1, RDD<Seq<Object>> x$2) {
                return x$1.union(x$2);
            }
        })).union(metrics.precisionByThreshold().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"precision", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "threshold", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).union(metrics.recallByThreshold().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"recall", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "threshold", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).union(metrics.pr().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"precision", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "recall", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).union(metrics.roc().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tp_rate", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "fp_rate", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).collect()), Seq$.MODULE$.canBuildFrom()), 1, ClassTag$.MODULE$.apply(Seq.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Seq<Object> x) {
                return Row$.MODULE$.fromSeq(x);
            }
        }, ClassTag$.MODULE$.apply(Row.class)) : dataset.sqlContext().sparkContext().parallelize((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), 1, ClassTag$.MODULE$.apply(Row.class));
        metrics.unpersist();
        Object object = SparkSqlUtils$.MODULE$.reflectionLock();
        synchronized (object) {
            Dataset dataset2 = dataset.sqlContext().createDataFrame(rows, this.transformSchema(dataset.schema()));
            return dataset2;
        }
    }

    @Override
    public BinaryClassificationEvaluator copy(ParamMap extra) {
        return (BinaryClassificationEvaluator)this.copyValues((Params)new BinaryClassificationEvaluator(), extra);
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        return new StructType().add("metric", (DataType)StringType$.MODULE$, false).add("value", (DataType)DoubleType$.MODULE$, false).add("x-metric", (DataType)StringType$.MODULE$, true).add("x-value", (DataType)DoubleType$.MODULE$, true);
    }

    public BinaryClassificationEvaluator(String uid) {
        super(uid);
        this.setDefault((Param)this.predictionIndex(), BoxesRunTime.boxToInteger((int)1));
        this.fmeasureThresholds = JacksonParam$.MODULE$.mapParam((Identifiable)this, "defaultValues", "Default values to assign to columns", JacksonParam$.MODULE$.mapParam$default$4(), JacksonParam$.MODULE$.mapParam$default$5(), ClassTag$.MODULE$.apply(Map.class));
        this.setDefault(this.fmeasureThresholds(), Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f1"), (Object)BoxesRunTime.boxToDouble((double)1.0))})));
        this.numBins = new IntParam((Identifiable)this, "numBins", "How many points to add to nested curves (recall/precision or roc)");
        this.setDefault((Param)this.numBins(), BoxesRunTime.boxToInteger((int)100));
    }

    public BinaryClassificationEvaluator() {
        this(Identifiable$.MODULE$.randomUID("binaryClassificationEvaluator"));
    }
}

