/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.odkl;

import java.io.Serializable;
import odkl.analysis.spark.util.Logging;
import odkl.analysis.spark.util.Logging$class;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.regression.IsotonicRegressionModel;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u00015\u0011!#S:pi>t\u0017n\u0019*fOJ,7o]5p]*\u00111\u0001B\u0001\u0005_\u0012\\GN\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qA\u0003\b\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012AA5p\u0015\u0005I\u0012\u0001\u00026bm\u0006L!a\u0007\f\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005u!S\"\u0001\u0010\u000b\u0005}\u0001\u0013\u0001B;uS2T!aB\u0011\u000b\u0005\t\u001a\u0013\u0001C1oC2L8/[:\u000b\u0003\rI!!\n\u0010\u0003\u000f1{wmZ5oO\"Aq\u0005\u0001BA\u0002\u0013%\u0001&\u0001\u0005jg>$xN\\5d+\u0005I\u0003CA\b+\u0013\tY\u0003CA\u0004C_>dW-\u00198\t\u00115\u0002!\u00111A\u0005\n9\nA\"[:pi>t\u0017nY0%KF$\"a\f\u001a\u0011\u0005=\u0001\u0014BA\u0019\u0011\u0005\u0011)f.\u001b;\t\u000fMb\u0013\u0011!a\u0001S\u0005\u0019\u0001\u0010J\u0019\t\u0011U\u0002!\u0011!Q!\n%\n\u0011\"[:pi>t\u0017n\u0019\u0011\t\u000b]\u0002A\u0011\u0002\u001d\u0002\rqJg.\u001b;?)\tI4\b\u0005\u0002;\u00015\t!\u0001C\u0003(m\u0001\u0007\u0011\u0006C\u00038\u0001\u0011\u0005Q\bF\u0001:Q\rat(\u0012\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u001a\t!\"\u00198o_R\fG/[8o\u0013\t!\u0015IA\u0003TS:\u001cW-I\u0001G\u0003\u0015\tdf\r\u00181\u0011\u0015A\u0005\u0001\"\u0001J\u0003-\u0019X\r^%t_R|g.[2\u0015\u0005)[U\"\u0001\u0001\t\u000b\u001d:\u0005\u0019A\u0015)\u0007\u001d{T\tC\u0003O\u0001\u0011\u0005q*A\u0002sk:$\"\u0001\u0015,\u0011\u0005E#V\"\u0001*\u000b\u0005M#\u0011A\u0003:fOJ,7o]5p]&\u0011QK\u0015\u0002\u0018\u0013N|Go\u001c8jGJ+wM]3tg&|g.T8eK2DQaV'A\u0002a\u000bQ!\u001b8qkR\u00042!\u0017/_\u001b\u0005Q&BA.\u0007\u0003\r\u0011H\rZ\u0005\u0003;j\u00131A\u0015#E!\u0015yq,Y1b\u0013\t\u0001\u0007C\u0001\u0004UkBdWm\r\t\u0003\u001f\tL!a\u0019\t\u0003\r\u0011{WO\u00197fQ\riu(\u0012\u0005\u0006\u001d\u0002!\tA\u001a\u000b\u0003!\u001eDQaV3A\u0002!\u00042![7p\u001b\u0005Q'BA\rl\u0015\tag!A\u0002ba&L!A\u001c6\u0003\u000f)\u000bg/\u0019*E\tB)qb\u00189qaB\u0011\u0011\u000f^\u0007\u0002e*\u00111\u000fG\u0001\u0005Y\u0006tw-\u0003\u0002de\"\u001aQmP#\t\u000b]\u0004A\u0011\u0002=\u0002+A|w\u000e\\!eU\u0006\u001cWM\u001c;WS>d\u0017\r^8sgR\u0011\u0011\u0010 \t\u0004\u001fit\u0016BA>\u0011\u0005\u0015\t%O]1z\u0011\u00159f\u000f1\u0001z\u0011\u0015q\b\u0001\"\u0003\u0000\u0003u\u0001\u0018M]1mY\u0016d\u0007k\\8m\u0003\u0012T\u0017mY3oiZKw\u000e\\1u_J\u001cHcA=\u0002\u0002!)q+ a\u00011\"\u001a\u0001aP#")
public class IsotonicRegression
implements Serializable,
Logging {
    private boolean isotonic;
    private transient Logger odkl$analysis$spark$util$Logging$$log_;

    @Override
    public Logger odkl$analysis$spark$util$Logging$$log_() {
        return this.odkl$analysis$spark$util$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void odkl$analysis$spark$util$Logging$$log__$eq(Logger x$1) {
        this.odkl$analysis$spark$util$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private boolean isotonic() {
        return this.isotonic;
    }

    private void isotonic_$eq(boolean x$1) {
        this.isotonic = x$1;
    }

    public IsotonicRegression setIsotonic(boolean isotonic) {
        this.isotonic_$eq(isotonic);
        return this;
    }

    public IsotonicRegressionModel run(RDD<Tuple3<Object, Object, Object>> input) {
        RDD preprocessedInput = this.isotonic() ? input : input.map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Object> apply(Tuple3<Object, Object, Object> x) {
                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)(-BoxesRunTime.unboxToDouble((Object)x._1()))), x._2(), x._3());
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        Tuple3<Object, Object, Object>[] pooled = this.parallelPoolAdjacentViolators(preprocessedInput);
        double[] predictions = this.isotonic() ? (double[])Predef$.MODULE$.refArrayOps((Object[])pooled).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> x$1) {
                return BoxesRunTime.unboxToDouble((Object)x$1._1());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : (double[])Predef$.MODULE$.refArrayOps((Object[])pooled).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> x$2) {
                return -BoxesRunTime.unboxToDouble((Object)x$2._1());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] boundaries = (double[])Predef$.MODULE$.refArrayOps((Object[])pooled).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> x$3) {
                return BoxesRunTime.unboxToDouble((Object)x$3._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        if (Predef$.MODULE$.double2Double(predictions[0]).isNaN()) {
            this.logWarning((Function0<String>)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Got NaN at the beginning of the predictions, replacing with 0.0";
                }
            });
            predictions[0] = 0.0;
        }
        if (Predef$.MODULE$.double2Double(boundaries[0]).isNaN()) {
            this.logWarning((Function0<String>)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Got NaN at the beginning of the boundaries, replacing with 0.0";
                }
            });
            boundaries[0] = 0.0;
        }
        return new IsotonicRegressionModel(boundaries, predictions, this.isotonic());
    }

    public IsotonicRegressionModel run(JavaRDD<Tuple3<Double, Double, Double>> input) {
        return this.run((RDD<Tuple3<Object, Object, Object>>)input.rdd().retag(ClassTag$.MODULE$.apply(Tuple3.class)));
    }

    public Tuple3<Object, Object, Object>[] org$apache$spark$mllib$odkl$IsotonicRegression$$poolAdjacentViolators(Tuple3<Object, Object, Object>[] input) {
        if (Predef$.MODULE$.refArrayOps((Object[])input).isEmpty()) {
            return (Tuple3[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple3.class));
        }
        int i = 0;
        int len = input.length;
        while (i < len) {
            int j;
            for (j = i; j < len - 1 && BoxesRunTime.unboxToDouble((Object)input[j]._1()) > BoxesRunTime.unboxToDouble((Object)input[j + 1]._1()); ++j) {
            }
            if (i == j) {
                ++i;
                continue;
            }
            while (i >= 0 && BoxesRunTime.unboxToDouble((Object)input[i]._1()) > BoxesRunTime.unboxToDouble((Object)input[i + 1]._1())) {
                this.pool$1(input, i, j);
                --i;
            }
            i = j;
        }
        ArrayBuffer compressed = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Tuple3 tuple3 = (Tuple3)Predef$.MODULE$.refArrayOps((Object[])input).head();
        if (tuple3 != null) {
            Tuple3 tuple32;
            double curLabel = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double curFeature = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            double curWeight = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)curLabel), (Object)BoxesRunTime.boxToDouble((double)curFeature), (Object)BoxesRunTime.boxToDouble((double)curWeight));
            DoubleRef curLabel2 = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)tuple33._1()));
            DoubleRef curFeature2 = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)tuple33._2()));
            DoubleRef curWeight2 = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)tuple33._3()));
            DoubleRef rightBound = DoubleRef.create((double)curFeature2.elem);
            for (i = 1; i < input.length; ++i) {
                Tuple3<Object, Object, Object> tuple34 = input[i];
                if (tuple34 != null) {
                    Tuple3 tuple35;
                    double label = BoxesRunTime.unboxToDouble((Object)tuple34._1());
                    double feature = BoxesRunTime.unboxToDouble((Object)tuple34._2());
                    double weight = BoxesRunTime.unboxToDouble((Object)tuple34._3());
                    Tuple3 tuple36 = tuple35 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)label), (Object)BoxesRunTime.boxToDouble((double)feature), (Object)BoxesRunTime.boxToDouble((double)weight));
                    double label2 = BoxesRunTime.unboxToDouble((Object)tuple36._1());
                    double feature2 = BoxesRunTime.unboxToDouble((Object)tuple36._2());
                    double weight2 = BoxesRunTime.unboxToDouble((Object)tuple36._3());
                    if (label2 == curLabel2.elem) {
                        curWeight2.elem += weight2;
                        rightBound.elem = feature2;
                        continue;
                    }
                    this.merge$1(compressed, curLabel2, curFeature2, curWeight2, rightBound);
                    curLabel2.elem = label2;
                    curFeature2.elem = feature2;
                    curWeight2.elem = weight2;
                    rightBound.elem = curFeature2.elem;
                    continue;
                }
                throw new MatchError(tuple34);
            }
            this.merge$1(compressed, curLabel2, curFeature2, curWeight2, rightBound);
            return (Tuple3[])compressed.toArray(ClassTag$.MODULE$.apply(Tuple3.class));
        }
        throw new MatchError((Object)tuple3);
    }

    private Tuple3<Object, Object, Object>[] parallelPoolAdjacentViolators(RDD<Tuple3<Object, Object, Object>> input) {
        Tuple3[] parallelStepResult = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])input.glom().flatMap((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsotonicRegression $outer;

            public final ArrayOps<Tuple3<Object, Object, Object>> apply(Tuple3<Object, Object, Object>[] arr) {
                return Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$mllib$odkl$IsotonicRegression$$poolAdjacentViolators((Tuple3[])Predef$.MODULE$.refArrayOps((Object[])arr).sortBy((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Tuple3<Object, Object, Object> x) {
                        return new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)x._2()), BoxesRunTime.unboxToDouble((Object)x._1()));
                    }
                }, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)).collect()).sortBy((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple3<Object, Object, Object> x) {
                return new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)x._2()), BoxesRunTime.unboxToDouble((Object)x._1()));
            }
        }, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$));
        return this.org$apache$spark$mllib$odkl$IsotonicRegression$$poolAdjacentViolators(parallelStepResult);
    }

    private final void pool$1(Tuple3[] input, int start2, int end) {
        DoubleRef weightedSum = DoubleRef.create((double)0.0);
        DoubleRef weight = DoubleRef.create((double)0.0);
        Predef$.MODULE$.refArrayOps((Object[])input).view().slice(start2, end + 1).foreach((Function1)new scala.Serializable(this, weightedSum, weight){
            public static final long serialVersionUID = 0L;
            private final DoubleRef weightedSum$1;
            private final DoubleRef weight$1;

            public final void apply(Tuple3<Object, Object, Object> x) {
                this.weightedSum$1.elem += BoxesRunTime.unboxToDouble((Object)x._1()) * BoxesRunTime.unboxToDouble((Object)x._3());
                this.weight$1.elem += BoxesRunTime.unboxToDouble((Object)x._3());
            }
            {
                this.weightedSum$1 = weightedSum$1;
                this.weight$1 = weight$1;
            }
        });
        double update2 = weight.elem != 0.0 ? weightedSum.elem / weight.elem : 0.0;
        for (int i = start2; i <= end; ++i) {
            input[i] = new Tuple3((Object)BoxesRunTime.boxToDouble((double)update2), input[i]._2(), input[i]._3());
        }
    }

    private final void merge$1(ArrayBuffer compressed$1, DoubleRef curLabel$1, DoubleRef curFeature$1, DoubleRef curWeight$1, DoubleRef rightBound$1) {
        compressed$1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)curLabel$1.elem), (Object)BoxesRunTime.boxToDouble((double)curFeature$1.elem), (Object)BoxesRunTime.boxToDouble((double)curWeight$1.elem)));
        if (rightBound$1.elem > curFeature$1.elem) {
            compressed$1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)curLabel$1.elem), (Object)BoxesRunTime.boxToDouble((double)rightBound$1.elem), (Object)BoxesRunTime.boxToDouble((double)0.0)));
        }
    }

    private IsotonicRegression(boolean isotonic) {
        this.isotonic = isotonic;
        Logging$class.$init$(this);
    }

    public IsotonicRegression() {
        this(true);
    }
}

